/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegationTokenRenewer
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewer.class);
    public static final String SCHEME = "hdfs";
    private Timer renewalTimer;
    private RMContext rmContext;
    private DelegationTokenCancelThread dtCancelThread = new DelegationTokenCancelThread();
    private ThreadPoolExecutor renewerService;
    private Set<DelegationTokenToRenew> delegationTokens = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<ApplicationId, Long> delayedRemovalMap = new ConcurrentHashMap<ApplicationId, Long>();
    private long tokenRemovalDelayMs;
    private Thread delayedRemovalThread;
    private ReadWriteLock serviceStateLock = new ReentrantReadWriteLock();
    private volatile boolean isServiceStarted;
    private LinkedBlockingQueue<DelegationTokenRenewerEvent> pendingEventQueue;
    private boolean tokenKeepAliveEnabled;

    public DelegationTokenRenewer() {
        super(DelegationTokenRenewer.class.getName());
    }

    @Override
    protected synchronized void serviceInit(Configuration conf) throws Exception {
        this.tokenKeepAliveEnabled = conf.getBoolean("yarn.log-aggregation-enable", false);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.setLocalSecretManagerAndServiceAddr();
        this.renewerService = this.createNewThreadPoolService(conf);
        this.pendingEventQueue = new LinkedBlockingQueue();
        this.renewalTimer = new Timer(true);
        super.serviceInit(conf);
    }

    protected ThreadPoolExecutor createNewThreadPoolService(Configuration conf) {
        int nThreads = conf.getInt("yarn.resourcemanager.delegation-token-renewer.thread-count", 50);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("DelegationTokenRenewer #%d").build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(5 < nThreads ? 5 : nThreads, nThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        pool.setThreadFactory(tf);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void setLocalSecretManagerAndServiceAddr() {
        RMDelegationTokenIdentifier.Renewer.setSecretManager(this.rmContext.getRMDelegationTokenSecretManager(), this.rmContext.getClientRMService().getBindAddress());
    }

    @Override
    protected void serviceStart() throws Exception {
        this.dtCancelThread.start();
        if (this.tokenKeepAliveEnabled) {
            this.delayedRemovalThread = new Thread((Runnable)new DelayedTokenRemovalRunnable(this.getConfig()), "DelayedTokenCanceller");
            this.delayedRemovalThread.start();
        }
        this.setLocalSecretManagerAndServiceAddr();
        this.serviceStateLock.writeLock().lock();
        this.isServiceStarted = true;
        this.serviceStateLock.writeLock().unlock();
        while (!this.pendingEventQueue.isEmpty()) {
            this.processDelegationTokenRenewerEvent(this.pendingEventQueue.take());
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelegationTokenRenewerEvent(DelegationTokenRenewerEvent evt) {
        this.serviceStateLock.readLock().lock();
        try {
            if (this.isServiceStarted) {
                this.renewerService.execute(new DelegationTokenRenewerRunnable(evt));
            } else {
                this.pendingEventQueue.add(evt);
            }
        }
        finally {
            this.serviceStateLock.readLock().unlock();
        }
    }

    @Override
    protected void serviceStop() {
        if (this.renewalTimer != null) {
            this.renewalTimer.cancel();
        }
        this.delegationTokens.clear();
        this.renewerService.shutdown();
        this.dtCancelThread.interrupt();
        try {
            this.dtCancelThread.join(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.tokenKeepAliveEnabled && this.delayedRemovalThread != null) {
            this.delayedRemovalThread.interrupt();
            try {
                this.delayedRemovalThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted while joining on delayed removal thread.", (Throwable)e);
            }
        }
    }

    private void addTokenToList(DelegationTokenToRenew t) {
        this.delegationTokens.add(t);
    }

    @VisibleForTesting
    public Set<Token<?>> getDelegationTokens() {
        HashSet tokens = new HashSet();
        for (DelegationTokenToRenew delegationToken : this.delegationTokens) {
            tokens.add(delegationToken.token);
        }
        return tokens;
    }

    public void addApplicationAsync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd) {
        this.processDelegationTokenRenewerEvent(new DelegationTokenRenewerAppSubmitEvent(applicationId, ts, shouldCancelAtEnd));
    }

    public void addApplicationSync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd) throws IOException {
        this.handleAppSubmitEvent(new DelegationTokenRenewerAppSubmitEvent(applicationId, ts, shouldCancelAtEnd));
    }

    private void handleAppSubmitEvent(DelegationTokenRenewerAppSubmitEvent evt) throws IOException {
        ApplicationId applicationId = evt.getApplicationId();
        Credentials ts = evt.getCredentials();
        boolean shouldCancelAtEnd = evt.shouldCancelAtEnd();
        if (ts == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering tokens for renewal for: appId = " + applicationId));
        }
        Collection<Token<? extends TokenIdentifier>> tokens = ts.getAllTokens();
        long now = System.currentTimeMillis();
        ArrayList<DelegationTokenToRenew> tokenList = new ArrayList<DelegationTokenToRenew>();
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (!token.isManaged()) continue;
            tokenList.add(new DelegationTokenToRenew(applicationId, token, this.getConfig(), now, shouldCancelAtEnd));
        }
        if (!tokenList.isEmpty()) {
            for (DelegationTokenToRenew dtr : tokenList) {
                this.renewToken(dtr);
            }
            for (DelegationTokenToRenew dtr : tokenList) {
                this.addTokenToList(dtr);
                this.setTimerForTokenRenewal(dtr);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Registering token for renewal for: service = " + dtr.token.getService() + " for appId = " + dtr.applicationId));
            }
        }
    }

    @VisibleForTesting
    protected void setTimerForTokenRenewal(DelegationTokenToRenew token) throws IOException {
        long expiresIn = token.expirationDate - System.currentTimeMillis();
        long renewIn = token.expirationDate - expiresIn / 10L;
        RenewalTimerTask tTask = new RenewalTimerTask(token);
        token.setTimerTask(tTask);
        this.renewalTimer.schedule(token.timerTask, new Date(renewIn));
    }

    @VisibleForTesting
    protected void renewToken(final DelegationTokenToRenew dttr) throws IOException {
        try {
            dttr.expirationDate = UserGroupInformation.getLoginUser().doAs(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    return dttr.token.renew(dttr.conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void cancelToken(DelegationTokenToRenew t) {
        if (t.shouldCancelAtEnd) {
            this.dtCancelThread.cancelToken(t.token, t.conf);
        } else {
            LOG.info((Object)("Did not cancel " + t));
        }
    }

    private void removeFailedDelegationToken(DelegationTokenToRenew t) {
        ApplicationId applicationId = t.applicationId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing failed delegation token for appid=" + applicationId + ";t=" + t.token.getService()));
        }
        this.delegationTokens.remove(t);
        if (t.timerTask != null) {
            t.timerTask.cancel();
        }
    }

    public void applicationFinished(ApplicationId applicationId) {
        this.processDelegationTokenRenewerEvent(new DelegationTokenRenewerEvent(applicationId, DelegationTokenRenewerEventType.FINISH_APPLICATION));
    }

    private void handleAppFinishEvent(DelegationTokenRenewerEvent evt) {
        if (!this.tokenKeepAliveEnabled) {
            this.removeApplicationFromRenewal(evt.getApplicationId());
        } else {
            this.delayedRemovalMap.put(evt.getApplicationId(), System.currentTimeMillis() + this.tokenRemovalDelayMs);
        }
    }

    public void updateKeepAliveApplications(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.delayedRemovalMap.put(appId, System.currentTimeMillis() + this.tokenRemovalDelayMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationFromRenewal(ApplicationId applicationId) {
        Set<DelegationTokenToRenew> set = this.delegationTokens;
        synchronized (set) {
            Iterator<DelegationTokenToRenew> it = this.delegationTokens.iterator();
            while (it.hasNext()) {
                DelegationTokenToRenew dttr = it.next();
                if (!dttr.applicationId.equals(applicationId)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing delegation token for appId=" + applicationId + "; token=" + dttr.token.getService()));
                }
                if (dttr.timerTask != null) {
                    dttr.timerTask.cancel();
                }
                this.cancelToken(dttr);
                it.remove();
            }
        }
    }

    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    private static class DelegationTokenRenewerEvent
    extends AbstractEvent<DelegationTokenRenewerEventType> {
        private ApplicationId appId;

        public DelegationTokenRenewerEvent(ApplicationId appId, DelegationTokenRenewerEventType type) {
            super(type);
            this.appId = appId;
        }

        public ApplicationId getApplicationId() {
            return this.appId;
        }
    }

    static enum DelegationTokenRenewerEventType {
        VERIFY_AND_START_APPLICATION,
        FINISH_APPLICATION;

    }

    private static class DelegationTokenRenewerAppSubmitEvent
    extends DelegationTokenRenewerEvent {
        private Credentials credentials;
        private boolean shouldCancelAtEnd;

        public DelegationTokenRenewerAppSubmitEvent(ApplicationId appId, Credentials credentails, boolean shouldCancelAtEnd) {
            super(appId, DelegationTokenRenewerEventType.VERIFY_AND_START_APPLICATION);
            this.credentials = credentails;
            this.shouldCancelAtEnd = shouldCancelAtEnd;
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public boolean shouldCancelAtEnd() {
            return this.shouldCancelAtEnd;
        }
    }

    private final class DelegationTokenRenewerRunnable
    implements Runnable {
        private DelegationTokenRenewerEvent evt;

        public DelegationTokenRenewerRunnable(DelegationTokenRenewerEvent evt) {
            this.evt = evt;
        }

        @Override
        public void run() {
            if (this.evt instanceof DelegationTokenRenewerAppSubmitEvent) {
                DelegationTokenRenewerAppSubmitEvent appSubmitEvt = (DelegationTokenRenewerAppSubmitEvent)this.evt;
                this.handleDTRenewerAppSubmitEvent(appSubmitEvt);
            } else if (((DelegationTokenRenewerEventType)((Object)this.evt.getType())).equals((Object)DelegationTokenRenewerEventType.FINISH_APPLICATION)) {
                DelegationTokenRenewer.this.handleAppFinishEvent(this.evt);
            }
        }

        private void handleDTRenewerAppSubmitEvent(DelegationTokenRenewerAppSubmitEvent event) {
            try {
                DelegationTokenRenewer.this.handleAppSubmitEvent(event);
                DelegationTokenRenewer.this.rmContext.getDispatcher().getEventHandler().handle(new RMAppEvent(event.getApplicationId(), RMAppEventType.START));
            }
            catch (Throwable t) {
                LOG.warn((Object)"Unable to add the application to the delegation token renewer.", t);
                DelegationTokenRenewer.this.rmContext.getDispatcher().getEventHandler().handle(new RMAppRejectedEvent(event.getApplicationId(), t.getMessage()));
            }
        }
    }

    private class DelayedTokenRemovalRunnable
    implements Runnable {
        private long waitTimeMs;

        DelayedTokenRemovalRunnable(Configuration conf) {
            this.waitTimeMs = conf.getLong("yarn.resourcemanager.delayed.delegation-token.removal-interval-ms", 30000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList toCancel = new ArrayList();
            while (!Thread.currentThread().isInterrupted()) {
                Iterator it = DelegationTokenRenewer.this.delayedRemovalMap.entrySet().iterator();
                toCancel.clear();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    if ((Long)e.getValue() >= System.currentTimeMillis()) continue;
                    toCancel.add(e.getKey());
                }
                for (ApplicationId appId : toCancel) {
                    DelegationTokenRenewer.this.removeApplicationFromRenewal(appId);
                    DelegationTokenRenewer.this.delayedRemovalMap.remove(appId);
                }
                DelayedTokenRemovalRunnable delayedTokenRemovalRunnable = this;
                synchronized (delayedTokenRemovalRunnable) {
                    try {
                        this.wait(this.waitTimeMs);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"Delayed Deletion Thread Interrupted. Shutting it down");
                        return;
                    }
                }
            }
        }
    }

    private class RenewalTimerTask
    extends TimerTask {
        private DelegationTokenToRenew dttr;
        private boolean cancelled = false;

        RenewalTimerTask(DelegationTokenToRenew t) {
            this.dttr = t;
        }

        @Override
        public synchronized void run() {
            if (this.cancelled) {
                return;
            }
            Token<?> token = this.dttr.token;
            try {
                DelegationTokenRenewer.this.renewToken(this.dttr);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Renewing delegation-token for:" + token.getService() + "; new expiration;" + this.dttr.expirationDate));
                }
                DelegationTokenRenewer.this.setTimerForTokenRenewal(this.dttr);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception renewing token" + token + ". Not rescheduled"), (Throwable)e);
                DelegationTokenRenewer.this.removeFailedDelegationToken(this.dttr);
            }
        }

        @Override
        public synchronized boolean cancel() {
            this.cancelled = true;
            return super.cancel();
        }
    }

    private static class DelegationTokenCancelThread
    extends Thread {
        private LinkedBlockingQueue<TokenWithConf> queue = new LinkedBlockingQueue();

        public DelegationTokenCancelThread() {
            super("Delegation Token Canceler");
            this.setDaemon(true);
        }

        public void cancelToken(Token<?> token, Configuration conf) {
            TokenWithConf tokenWithConf = new TokenWithConf(token, conf);
            while (!this.queue.offer(tokenWithConf)) {
                LOG.warn((Object)("Unable to add token " + token + " for cancellation. " + "Will retry.."));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void run() {
            TokenWithConf tokenWithConf = null;
            while (true) {
                try {
                    while (true) {
                        final TokenWithConf current = tokenWithConf = this.queue.take();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Canceling token " + tokenWithConf.token.getService()));
                        }
                        UserGroupInformation.getLoginUser().doAs(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                current.token.cancel(current.conf);
                                return null;
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to cancel token " + tokenWithConf.token + " " + StringUtils.stringifyException(e)));
                    continue;
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)("Failed to cancel token " + tokenWithConf.token + " " + StringUtils.stringifyException(e)));
                    continue;
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Got exception " + StringUtils.stringifyException(t) + ". Exiting.."));
                    System.exit(-1);
                    continue;
                }
                break;
            }
        }

        private static class TokenWithConf {
            Token<?> token;
            Configuration conf;

            TokenWithConf(Token<?> token, Configuration conf) {
                this.token = token;
                this.conf = conf;
            }
        }
    }

    @VisibleForTesting
    protected static class DelegationTokenToRenew {
        public final Token<?> token;
        public final ApplicationId applicationId;
        public final Configuration conf;
        public long expirationDate;
        public TimerTask timerTask;
        public final boolean shouldCancelAtEnd;

        public DelegationTokenToRenew(ApplicationId jId, Token<?> token, Configuration conf, long expirationDate, boolean shouldCancelAtEnd) {
            this.token = token;
            this.applicationId = jId;
            this.conf = conf;
            this.expirationDate = expirationDate;
            this.timerTask = null;
            this.shouldCancelAtEnd = shouldCancelAtEnd;
            if (this.token == null || this.applicationId == null || this.conf == null) {
                throw new IllegalArgumentException("Invalid params to renew token;token=" + this.token + ";appId=" + this.applicationId + ";conf=" + this.conf);
            }
        }

        public void setTimerTask(TimerTask tTask) {
            this.timerTask = tTask;
        }

        public String toString() {
            return this.token + ";exp=" + this.expirationDate;
        }

        public boolean equals(Object obj) {
            return obj instanceof DelegationTokenToRenew && this.token.equals(((DelegationTokenToRenew)obj).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }
    }
}

