/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security.authorize;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.yarn.api.ApplicationClientProtocolPB;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocolPB;
import org.apache.hadoop.yarn.api.ContainerManagementProtocolPB;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocolPB;
import org.apache.hadoop.yarn.server.api.ResourceTrackerPB;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMPolicyProvider
extends PolicyProvider {
    private static RMPolicyProvider rmPolicyProvider = null;
    private static final Service[] resourceManagerServices = new Service[]{new Service("security.resourcetracker.protocol.acl", ResourceTrackerPB.class), new Service("security.applicationclient.protocol.acl", ApplicationClientProtocolPB.class), new Service("security.applicationmaster.protocol.acl", ApplicationMasterProtocolPB.class), new Service("security.resourcemanager-administration.protocol.acl", ResourceManagerAdministrationProtocolPB.class), new Service("security.containermanagement.protocol.acl", ContainerManagementProtocolPB.class), new Service("security.ha.service.protocol.acl", HAServiceProtocol.class)};

    private RMPolicyProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static RMPolicyProvider getInstance() {
        if (rmPolicyProvider != null) return rmPolicyProvider;
        Class<RMPolicyProvider> clazz = RMPolicyProvider.class;
        synchronized (RMPolicyProvider.class) {
            if (rmPolicyProvider != null) return rmPolicyProvider;
            rmPolicyProvider = new RMPolicyProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return rmPolicyProvider;
        }
    }

    @Override
    public Service[] getServices() {
        return resourceManagerServices;
    }
}

