/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class ContainerBlock
extends HtmlBlock {
    private static final Log LOG = LogFactory.getLog(ContainerBlock.class);
    private final ApplicationContext appContext;

    @Inject
    public ContainerBlock(ApplicationContext appContext, View.ViewContext ctx) {
        super(ctx);
        this.appContext = appContext;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        ContainerReport containerReport;
        String containerid = this.$("container.id");
        if (containerid.isEmpty()) {
            this.puts("Bad request: requires container ID");
            return;
        }
        ContainerId containerId = null;
        try {
            containerId = ConverterUtils.toContainerId(containerid);
        }
        catch (IllegalArgumentException e) {
            this.puts("Invalid container ID: " + containerid);
            return;
        }
        try {
            containerReport = this.appContext.getContainer(containerId);
        }
        catch (IOException e) {
            String message = "Failed to read the container " + containerid + ".";
            LOG.error((Object)message, (Throwable)e);
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
            return;
        }
        if (containerReport == null) {
            this.puts("Container not found: " + containerid);
            return;
        }
        ContainerInfo container = new ContainerInfo(containerReport);
        this.setTitle(StringHelper.join("Container ", containerid));
        this.info("Container Overview")._("State:", (Object)container.getContainerState())._("Exit Status:", container.getContainerExitStatus())._("Node:", container.getAssignedNodeId())._("Priority:", container.getPriority())._("Started:", Times.format(container.getStartedTime()))._("Elapsed:", StringUtils.formatTime(Times.elapsed(container.getStartedTime(), container.getFinishedTime())))._("Resource:", container.getAllocatedMB() + " Memory, " + container.getAllocatedVCores() + " VCores")._("Logs:", container.getLogUrl() == null ? "#" : container.getLogUrl(), container.getLogUrl() == null ? "N/A" : "Logs")._("Diagnostics:", container.getDiagnosticsInfo());
        html._(InfoBlock.class);
    }
}

