/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.timeline;

import java.io.IOException;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonGenerationException;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.JsonMappingException;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.ObjectMapper;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.annotate.JsonSerialize;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimelineUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String dumpTimelineRecordtoJSON(Object o) throws JsonGenerationException, JsonMappingException, IOException {
        return TimelineUtils.dumpTimelineRecordtoJSON(o, false);
    }

    public static String dumpTimelineRecordtoJSON(Object o, boolean pretty) throws JsonGenerationException, JsonMappingException, IOException {
        if (pretty) {
            return mapper.defaultPrettyPrintingWriter().writeValueAsString(o);
        }
        return mapper.writeValueAsString(o);
    }

    static {
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.setAnnotationIntrospector(introspector);
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

