/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.multipart;

import java.io.IOException;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpConstants;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.multipart.AbstractDiskHttpData;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.multipart.Attribute;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;

public class DiskAttribute
extends AbstractDiskHttpData
implements Attribute {
    public static String baseDirectory;
    public static boolean deleteOnExitTemporaryFile;
    public static final String prefix = "Attr_";
    public static final String postfix = ".att";

    public DiskAttribute(String name) {
        super(name, HttpConstants.DEFAULT_CHARSET, 0L);
    }

    public DiskAttribute(String name, String value) throws IOException {
        super(name, HttpConstants.DEFAULT_CHARSET, 0L);
        this.setValue(value);
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.Attribute;
    }

    public String getValue() throws IOException {
        byte[] bytes = this.get();
        return new String(bytes, this.charset.name());
    }

    public void setValue(String value) throws IOException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        byte[] bytes = value.getBytes(this.charset.name());
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(bytes);
        if (this.definedSize > 0L) {
            this.definedSize = buffer.readableBytes();
        }
        this.setContent(buffer);
    }

    public void addContent(ChannelBuffer buffer, boolean last) throws IOException {
        int localsize = buffer.readableBytes();
        if (this.definedSize > 0L && this.definedSize < this.size + (long)localsize) {
            this.definedSize = this.size + (long)localsize;
        }
        super.addContent(buffer, last);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    public int compareTo(InterfaceHttpData o) {
        if (!(o instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)o.getHttpDataType()));
        }
        return this.compareTo((Attribute)o);
    }

    public int compareTo(Attribute o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        try {
            return this.getName() + '=' + this.getValue();
        }
        catch (IOException e) {
            return this.getName() + "=IoException";
        }
    }

    protected boolean deleteOnExit() {
        return deleteOnExitTemporaryFile;
    }

    protected String getBaseDirectory() {
        return baseDirectory;
    }

    protected String getDiskFilename() {
        return this.getName() + postfix;
    }

    protected String getPostfix() {
        return postfix;
    }

    protected String getPrefix() {
        return prefix;
    }

    static {
        deleteOnExitTemporaryFile = true;
    }
}

