/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.security.UserGroupInformation;

public class TestFileSystem
extends TestCase {
    private static final Log LOG = FileSystem.LOG;
    private static Configuration conf = new Configuration();
    private static int BUFFER_SIZE = conf.getInt("io.file.buffer.size", 4096);
    private static final long MEGA = 0x100000L;
    private static final int SEEKS_PER_FILE = 4;
    private static String ROOT = System.getProperty("test.build.data", "fs_test");
    private static Path CONTROL_DIR = new Path(ROOT, "fs_control");
    private static Path WRITE_DIR = new Path(ROOT, "fs_write");
    private static Path READ_DIR = new Path(ROOT, "fs_read");
    private static Path DATA_DIR = new Path(ROOT, "fs_data");

    public void testFs() throws Exception {
        TestFileSystem.testFs(0xA00000L, 100, 0L);
    }

    public static void testFs(long megaBytes, int numFiles, long seed) throws Exception {
        FileSystem fs = FileSystem.get(conf);
        if (seed == 0L) {
            seed = new Random().nextLong();
        }
        LOG.info((Object)("seed = " + seed));
        TestFileSystem.createControlFile(fs, megaBytes, numFiles, seed);
        TestFileSystem.writeTest(fs, false);
        TestFileSystem.readTest(fs, false);
        TestFileSystem.seekTest(fs, false);
        fs.delete(CONTROL_DIR, true);
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        fs.delete(READ_DIR, true);
    }

    public static void testCommandFormat() throws Exception {
        CommandFormat cf = new CommandFormat("copyToLocal", 2, 2, "crc", "ignoreCrc");
        TestFileSystem.assertEquals((String)cf.parse(new String[]{"-get", "file", "-"}, 1).get(1), (String)"-");
        try {
            cf.parse(new String[]{"-get", "file", "-ignoreCrc", "/foo"}, 1);
            TestFileSystem.fail((String)"Expected parsing to fail as it should stop at first non-option");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cf = new CommandFormat("tail", 1, 1, "f");
        TestFileSystem.assertEquals((String)cf.parse(new String[]{"-tail", "fileName"}, 1).get(0), (String)"fileName");
        TestFileSystem.assertEquals((String)cf.parse(new String[]{"-tail", "-f", "fileName"}, 1).get(0), (String)"fileName");
        cf = new CommandFormat("setrep", 2, 2, "R", "w");
        TestFileSystem.assertEquals((String)cf.parse(new String[]{"-setrep", "-R", "2", "/foo/bar"}, 1).get(1), (String)"/foo/bar");
        cf = new CommandFormat("put", 2, 10000, new String[0]);
        TestFileSystem.assertEquals((String)cf.parse(new String[]{"-put", "-", "dest"}, 1).get(1), (String)"dest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createControlFile(FileSystem fs, long megaBytes, int numFiles, long seed) throws Exception {
        long totalSize;
        LOG.info((Object)("creating control file: " + megaBytes + " bytes, " + numFiles + " files"));
        Path controlFile = new Path(CONTROL_DIR, "files");
        fs.delete(controlFile, true);
        Random random = new Random(seed);
        SequenceFile.Writer writer = SequenceFile.createWriter(fs, conf, controlFile, Text.class, LongWritable.class, SequenceFile.CompressionType.NONE);
        long maxSize = megaBytes / (long)numFiles * 2L + 1L;
        try {
            long size;
            for (totalSize = 0L; totalSize < megaBytes; totalSize += size) {
                Text name = new Text(Long.toString(random.nextLong()));
                size = random.nextLong();
                if (size < 0L) {
                    size = -size;
                }
                writer.append(name, new LongWritable(size %= maxSize));
            }
        }
        finally {
            writer.close();
        }
        LOG.info((Object)("created control file for: " + totalSize + " bytes"));
    }

    public static void writeTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths(job, CONTROL_DIR);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(WriteMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath(job, WRITE_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob(job);
    }

    public static void readTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(READ_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths(job, CONTROL_DIR);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(ReadMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath(job, READ_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob(job);
    }

    public static void seekTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(READ_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths(job, CONTROL_DIR);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(SeekMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath(job, READ_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob(job);
    }

    public static void main(String[] args) throws Exception {
        int megaBytes = 10;
        int files = 100;
        boolean noRead = false;
        boolean noWrite = false;
        boolean noSeek = false;
        boolean fastCheck = false;
        long seed = new Random().nextLong();
        String usage = "Usage: TestFileSystem -files N -megaBytes M [-noread] [-nowrite] [-noseek] [-fastcheck]";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-files")) {
                files = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-megaBytes")) {
                megaBytes = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-noread")) {
                noRead = true;
                continue;
            }
            if (args[i].equals("-nowrite")) {
                noWrite = true;
                continue;
            }
            if (args[i].equals("-noseek")) {
                noSeek = true;
                continue;
            }
            if (!args[i].equals("-fastcheck")) continue;
            fastCheck = true;
        }
        LOG.info((Object)("seed = " + seed));
        LOG.info((Object)("files = " + files));
        LOG.info((Object)("megaBytes = " + megaBytes));
        FileSystem fs = FileSystem.get(conf);
        if (!noWrite) {
            TestFileSystem.createControlFile(fs, (long)megaBytes * 0x100000L, files, seed);
            TestFileSystem.writeTest(fs, fastCheck);
        }
        if (!noRead) {
            TestFileSystem.readTest(fs, fastCheck);
        }
        if (!noSeek) {
            TestFileSystem.seekTest(fs, fastCheck);
        }
    }

    public void testFsCache() throws Exception {
        long now = System.currentTimeMillis();
        String[] users = new String[]{"foo", "bar"};
        final Configuration conf = new Configuration();
        FileSystem[] fs = new FileSystem[users.length];
        for (int i = 0; i < users.length; ++i) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser(users[i]);
            fs[i] = ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return FileSystem.get(conf);
                }
            });
            for (int j = 0; j < i; ++j) {
                TestFileSystem.assertFalse((fs[j] == fs[i] ? 1 : 0) != 0);
            }
        }
        FileSystem.closeAll();
        try {
            TestFileSystem.runTestCache(8020);
        }
        catch (BindException be) {
            LOG.warn((Object)"Cannot test NameNode.DEFAULT_PORT (=8020)", (Throwable)be);
        }
        TestFileSystem.runTestCache(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runTestCache(int port) throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).nameNodePort(port).numDataNodes(2).build();
            URI uri = cluster.getFileSystem().getUri();
            LOG.info((Object)("uri=" + uri));
            FileSystem fs = FileSystem.get(uri, new Configuration());
            TestFileSystem.checkPath(cluster, fs);
            for (int i = 0; i < 100; ++i) {
                TestFileSystem.assertTrue((fs == FileSystem.get(uri, new Configuration()) ? 1 : 0) != 0);
            }
            if (port == 8020) {
                URI uri2 = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 8020, uri.getPath(), uri.getQuery(), uri.getFragment());
                LOG.info((Object)("uri2=" + uri2));
                FileSystem fs2 = FileSystem.get(uri2, conf);
                TestFileSystem.checkPath(cluster, fs2);
                for (int i = 0; i < 100; ++i) {
                    TestFileSystem.assertTrue((fs2 == FileSystem.get(uri2, new Configuration()) ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void checkPath(MiniDFSCluster cluster, FileSystem fileSys) throws IOException {
        InetSocketAddress add = cluster.getNameNode().getNameNodeAddress();
        fileSys.checkPath(new Path("hdfs://" + add.getHostName().toUpperCase() + ":" + add.getPort()));
    }

    public void testFsClose() throws Exception {
        Configuration conf = new Configuration();
        new Path("file:///").getFileSystem(conf);
        FileSystem.closeAll();
        conf = new Configuration();
        new Path("hftp://localhost:12345/").getFileSystem(conf);
        FileSystem.closeAll();
        conf = new Configuration();
        FileSystem fs = new Path("hftp://localhost:12345/").getFileSystem(conf);
        FileSystem.closeAll();
    }

    public void testFsShutdownHook() throws Exception {
        Set<FileSystem> closed = Collections.synchronizedSet(new HashSet());
        Configuration conf = new Configuration();
        Configuration confNoAuto = new Configuration();
        conf.setClass("fs.test.impl", TestShutdownFileSystem.class, FileSystem.class);
        confNoAuto.setClass("fs.test.impl", TestShutdownFileSystem.class, FileSystem.class);
        confNoAuto.setBoolean("fs.automatic.close", false);
        TestShutdownFileSystem fsWithAuto = (TestShutdownFileSystem)new Path("test://a/").getFileSystem(conf);
        TestShutdownFileSystem fsWithoutAuto = (TestShutdownFileSystem)new Path("test://b/").getFileSystem(confNoAuto);
        fsWithAuto.setClosedSet(closed);
        fsWithoutAuto.setClosedSet(closed);
        TestFileSystem.assertNotSame((Object)fsWithAuto, (Object)fsWithoutAuto);
        FileSystem.CACHE.closeAll(true);
        TestFileSystem.assertEquals((int)1, (int)closed.size());
        TestFileSystem.assertTrue((boolean)closed.contains(fsWithAuto));
        closed.clear();
        FileSystem.closeAll();
        TestFileSystem.assertEquals((int)1, (int)closed.size());
        TestFileSystem.assertTrue((boolean)closed.contains(fsWithoutAuto));
    }

    public void testCacheKeysAreCaseInsensitive() throws Exception {
        Configuration conf = new Configuration();
        FileSystem.Cache.Key lowercaseCachekey1 = new FileSystem.Cache.Key(new URI("hftp://localhost:12345/"), conf);
        FileSystem.Cache.Key lowercaseCachekey2 = new FileSystem.Cache.Key(new URI("hftp://localhost:12345/"), conf);
        TestFileSystem.assertEquals((Object)lowercaseCachekey1, (Object)lowercaseCachekey2);
        FileSystem.Cache.Key uppercaseCachekey = new FileSystem.Cache.Key(new URI("HFTP://Localhost:12345/"), conf);
        TestFileSystem.assertEquals((Object)lowercaseCachekey2, (Object)uppercaseCachekey);
        ArrayList<FileSystem.Cache.Key> list = new ArrayList<FileSystem.Cache.Key>();
        list.add(uppercaseCachekey);
        TestFileSystem.assertTrue((boolean)list.contains(uppercaseCachekey));
        TestFileSystem.assertTrue((boolean)list.contains(lowercaseCachekey2));
        HashSet<FileSystem.Cache.Key> set = new HashSet<FileSystem.Cache.Key>();
        set.add(uppercaseCachekey);
        TestFileSystem.assertTrue((boolean)set.contains(uppercaseCachekey));
        TestFileSystem.assertTrue((boolean)set.contains(lowercaseCachekey2));
        HashMap<FileSystem.Cache.Key, String> map = new HashMap<FileSystem.Cache.Key, String>();
        map.put(uppercaseCachekey, "");
        TestFileSystem.assertTrue((boolean)map.containsKey(uppercaseCachekey));
        TestFileSystem.assertTrue((boolean)map.containsKey(lowercaseCachekey2));
    }

    public static void testFsUniqueness(long megaBytes, int numFiles, long seed) throws Exception {
        FileSystem fs2;
        FileSystem fs1 = FileSystem.get(conf);
        TestFileSystem.assertTrue((fs1 == (fs2 = FileSystem.get(conf)) ? 1 : 0) != 0);
        fs1 = FileSystem.newInstance(conf);
        fs2 = FileSystem.newInstance(conf);
        TestFileSystem.assertTrue((fs1 != fs2 && !fs1.equals(fs2) ? 1 : 0) != 0);
        fs1.close();
        fs2.close();
    }

    static /* synthetic */ int access$000() {
        return BUFFER_SIZE;
    }

    public static class TestShutdownFileSystem
    extends RawLocalFileSystem {
        private Set<FileSystem> closedSet;

        public void setClosedSet(Set<FileSystem> closedSet) {
            this.closedSet = closedSet;
        }

        @Override
        public void close() throws IOException {
            if (this.closedSet != null) {
                this.closedSet.add(this);
            }
            super.close();
        }
    }

    public static class SeekMapper<K>
    extends Configured
    implements Mapper<Text, LongWritable, K, LongWritable> {
        private Random random = new Random();
        private byte[] check = new byte[TestFileSystem.access$000()];
        private FileSystem fs;
        private boolean fastCheck;

        public SeekMapper() {
            super(null);
            try {
                this.fs = FileSystem.get(conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public SeekMapper(Configuration conf) {
            super(conf);
            try {
                this.fs = FileSystem.get(conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void configure(JobConf job) {
            this.setConf(job);
            this.fastCheck = job.getBoolean("fs.test.fastCheck", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void map(Text key, LongWritable value, OutputCollector<K, LongWritable> collector, Reporter reporter) throws IOException {
            String name = key.toString();
            long size = value.get();
            long seed = Long.parseLong(name);
            if (size == 0L) {
                return;
            }
            reporter.setStatus("opening " + name);
            FSDataInputStream in = this.fs.open(new Path(DATA_DIR, name));
            try {
                for (int i = 0; i < 4; ++i) {
                    long position = Math.abs(this.random.nextLong()) % size;
                    reporter.setStatus("seeking " + name);
                    in.seek(position);
                    byte b = in.readByte();
                    byte checkByte = 0;
                    this.random.setSeed(seed);
                    int p = 0;
                    while ((long)p <= position) {
                        reporter.setStatus("generating data for " + name);
                        if (this.fastCheck) {
                            checkByte = (byte)this.random.nextInt(127);
                        } else {
                            this.random.nextBytes(this.check);
                            checkByte = this.check[(int)(position % (long)this.check.length)];
                        }
                        p += this.check.length;
                    }
                    Assert.assertEquals((byte)b, (byte)checkByte);
                }
            }
            finally {
                in.close();
            }
        }

        @Override
        public void close() {
        }
    }

    public static class ReadMapper
    extends Configured
    implements Mapper<Text, LongWritable, Text, LongWritable> {
        private Random random = new Random();
        private byte[] buffer = new byte[TestFileSystem.access$000()];
        private byte[] check = new byte[TestFileSystem.access$000()];
        private FileSystem fs;
        private boolean fastCheck;

        public ReadMapper() {
            super(null);
            try {
                this.fs = FileSystem.get(conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ReadMapper(Configuration conf) {
            super(conf);
            try {
                this.fs = FileSystem.get(conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void configure(JobConf job) {
            this.setConf(job);
            this.fastCheck = job.getBoolean("fs.test.fastCheck", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void map(Text key, LongWritable value, OutputCollector<Text, LongWritable> collector, Reporter reporter) throws IOException {
            String name = key.toString();
            long size = value.get();
            long seed = Long.parseLong(name);
            this.random.setSeed(seed);
            reporter.setStatus("opening " + name);
            DataInputStream in = new DataInputStream(this.fs.open(new Path(DATA_DIR, name)));
            long read = 0L;
            try {
                while (read < size) {
                    long remains = size - read;
                    int n = remains <= (long)this.buffer.length ? (int)remains : this.buffer.length;
                    in.readFully(this.buffer, 0, n);
                    read += (long)n;
                    if (this.fastCheck) {
                        Arrays.fill(this.check, (byte)this.random.nextInt(127));
                    } else {
                        this.random.nextBytes(this.check);
                    }
                    if (n != this.buffer.length) {
                        Arrays.fill(this.buffer, n, this.buffer.length, (byte)0);
                        Arrays.fill(this.check, n, this.check.length, (byte)0);
                    }
                    Assert.assertTrue((boolean)Arrays.equals(this.buffer, this.check));
                    reporter.setStatus("reading " + name + "@" + read + "/" + size);
                }
            }
            finally {
                in.close();
            }
            collector.collect(new Text("bytes"), new LongWritable(read));
            reporter.setStatus("read " + name);
        }

        @Override
        public void close() {
        }
    }

    public static class WriteMapper
    extends Configured
    implements Mapper<Text, LongWritable, Text, LongWritable> {
        private Random random = new Random();
        private byte[] buffer = new byte[TestFileSystem.access$000()];
        private FileSystem fs;
        private boolean fastCheck;
        private String suffix = "-" + this.random.nextLong();

        public WriteMapper() {
            super(null);
            try {
                this.fs = FileSystem.get(conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public WriteMapper(Configuration conf) {
            super(conf);
            try {
                this.fs = FileSystem.get(conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void configure(JobConf job) {
            this.setConf(job);
            this.fastCheck = job.getBoolean("fs.test.fastCheck", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void map(Text key, LongWritable value, OutputCollector<Text, LongWritable> collector, Reporter reporter) throws IOException {
            String name = key.toString();
            long size = value.get();
            long seed = Long.parseLong(name);
            this.random.setSeed(seed);
            reporter.setStatus("creating " + name);
            Path tempFile = new Path(DATA_DIR, name + this.suffix);
            FSDataOutputStream out = this.fs.create(tempFile);
            long written = 0L;
            try {
                while (written < size) {
                    if (this.fastCheck) {
                        Arrays.fill(this.buffer, (byte)this.random.nextInt(127));
                    } else {
                        this.random.nextBytes(this.buffer);
                    }
                    long remains = size - written;
                    int length = remains <= (long)this.buffer.length ? (int)remains : this.buffer.length;
                    ((OutputStream)out).write(this.buffer, 0, length);
                    reporter.setStatus("writing " + name + "@" + (written += (long)length) + "/" + size);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
            this.fs.rename(tempFile, new Path(DATA_DIR, name));
            collector.collect(new Text("bytes"), new LongWritable(written));
            reporter.setStatus("wrote " + name);
        }

        @Override
        public void close() {
        }
    }
}

