/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextMainOperationsBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalFSFileContextMainOperations
extends FileContextMainOperationsBaseTest {
    static Path wd = null;

    @Override
    @Before
    public void setUp() throws Exception {
        fc = FileContext.getLocalFSFileContext();
        super.setUp();
    }

    @Override
    protected Path getDefaultWorkingDirectory() throws IOException {
        if (wd == null) {
            wd = FileSystem.getLocal(new Configuration()).getWorkingDirectory();
        }
        return wd;
    }

    @Test
    public void testFileContextNoCache() throws UnsupportedFileSystemException {
        FileContext fc1 = FileContext.getLocalFSFileContext();
        Assert.assertTrue((fc1 != fc ? 1 : 0) != 0);
    }

    @Override
    protected boolean listCorruptedBlocksSupported() {
        return false;
    }

    @Test
    public void testDefaultFilePermission() throws IOException {
        Path file = this.fileContextTestHelper.getTestRootPath(fc, "testDefaultFilePermission");
        FileContextTestHelper.createFile(fc, file);
        FsPermission expect = FileContext.FILE_DEFAULT_PERM.applyUMask(fc.getUMask());
        Assert.assertEquals((Object)expect, (Object)fc.getFileStatus(file).getPermission());
    }
}

