/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3.Block;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class INode {
    public static final FileType[] FILE_TYPES = new FileType[]{FileType.DIRECTORY, FileType.FILE};
    public static final INode DIRECTORY_INODE = new INode(FileType.DIRECTORY, null);
    private FileType fileType;
    private Block[] blocks;

    public INode(FileType fileType2, Block[] blocks) {
        this.fileType = fileType2;
        if (this.isDirectory() && blocks != null) {
            throw new IllegalArgumentException("A directory cannot contain blocks.");
        }
        this.blocks = blocks;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isDirectory() {
        return this.fileType == FileType.DIRECTORY;
    }

    public boolean isFile() {
        return this.fileType == FileType.FILE;
    }

    public long getSerializedLength() {
        return 1L + (long)(this.blocks == null ? 0 : 4 + this.blocks.length * 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream serialize() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            out.writeByte(this.fileType.ordinal());
            if (this.isFile()) {
                out.writeInt(this.blocks.length);
                for (int i = 0; i < this.blocks.length; ++i) {
                    out.writeLong(this.blocks[i].getId());
                    out.writeLong(this.blocks[i].getLength());
                }
            }
            out.close();
            out = null;
        }
        finally {
            IOUtils.closeStream(out);
        }
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    public static INode deserialize(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        DataInputStream dataIn = new DataInputStream(in);
        FileType fileType2 = FILE_TYPES[dataIn.readByte()];
        switch (fileType2) {
            case DIRECTORY: {
                in.close();
                return DIRECTORY_INODE;
            }
            case FILE: {
                int numBlocks = dataIn.readInt();
                Block[] blocks = new Block[numBlocks];
                for (int i = 0; i < numBlocks; ++i) {
                    long id = dataIn.readLong();
                    long length = dataIn.readLong();
                    blocks[i] = new Block(id, length);
                }
                in.close();
                return new INode(fileType2, blocks);
            }
        }
        throw new IllegalArgumentException("Cannot deserialize inode.");
    }

    static enum FileType {
        DIRECTORY,
        FILE;

    }
}

