/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFileSystemDelegationTokenSupport {
    private static final String MOUNT_TABLE_NAME = "vfs-cluster";
    static Configuration conf;
    static FileSystem viewFs;
    static FakeFileSystem fs1;
    static FakeFileSystem fs2;

    @BeforeClass
    public static void setup() throws Exception {
        conf = ViewFileSystemTestSetup.createConfig();
        fs1 = TestViewFileSystemDelegationTokenSupport.setupFileSystem(new URI("fs1:///"), FakeFileSystem.class);
        fs2 = TestViewFileSystemDelegationTokenSupport.setupFileSystem(new URI("fs2:///"), FakeFileSystem.class);
        viewFs = FileSystem.get(FsConstants.VIEWFS_URI, conf);
    }

    static FakeFileSystem setupFileSystem(URI uri, Class<? extends FileSystem> clazz) throws Exception {
        String scheme = uri.getScheme();
        conf.set("fs." + scheme + ".impl", clazz.getName());
        FakeFileSystem fs = (FakeFileSystem)FileSystem.get(uri, conf);
        ConfigUtil.addLink(conf, "/mounts/" + scheme + "-one", fs.getUri());
        ConfigUtil.addLink(conf, "/mounts/" + scheme + "-two", fs.getUri());
        return fs;
    }

    @Test
    public void testGetCanonicalServiceNameWithNonDefaultMountTable() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        ConfigUtil.addLink(conf, MOUNT_TABLE_NAME, "/user", new URI("file:///"));
        FileSystem viewFs = FileSystem.get(new URI("viewfs://vfs-cluster"), conf);
        String serviceName = viewFs.getCanonicalServiceName();
        Assert.assertNull((Object)serviceName);
    }

    @Test
    public void testGetCanonicalServiceNameWithDefaultMountTable() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        ConfigUtil.addLink(conf, "/user", new URI("file:///"));
        FileSystem viewFs = FileSystem.get(FsConstants.VIEWFS_URI, conf);
        String serviceName = viewFs.getCanonicalServiceName();
        Assert.assertNull((Object)serviceName);
    }

    @Test
    public void testGetChildFileSystems() throws Exception {
        Assert.assertNull((Object)fs1.getChildFileSystems());
        Assert.assertNull((Object)fs2.getChildFileSystems());
        List<FileSystem> children = Arrays.asList(viewFs.getChildFileSystems());
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertTrue((boolean)children.contains(fs1));
        Assert.assertTrue((boolean)children.contains(fs2));
    }

    @Test
    public void testAddDelegationTokens() throws Exception {
        Credentials creds = new Credentials();
        Token<?>[] fs1Tokens = this.addTokensWithCreds(fs1, creds);
        Assert.assertEquals((long)1L, (long)fs1Tokens.length);
        Assert.assertEquals((long)1L, (long)creds.numberOfTokens());
        Token<?>[] fs2Tokens = this.addTokensWithCreds(fs2, creds);
        Assert.assertEquals((long)1L, (long)fs2Tokens.length);
        Assert.assertEquals((long)2L, (long)creds.numberOfTokens());
        Credentials savedCreds = creds;
        creds = new Credentials();
        Token<?>[] viewFsTokens = viewFs.addDelegationTokens("me", creds);
        Assert.assertEquals((long)2L, (long)viewFsTokens.length);
        Assert.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assert.assertEquals((long)savedCreds.numberOfTokens(), (long)creds.numberOfTokens());
        viewFsTokens = viewFs.addDelegationTokens("me", creds);
        Assert.assertEquals((long)0L, (long)viewFsTokens.length);
        Assert.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assert.assertEquals((long)savedCreds.numberOfTokens(), (long)creds.numberOfTokens());
    }

    Token<?>[] addTokensWithCreds(FileSystem fs, Credentials creds) throws Exception {
        Credentials savedCreds = new Credentials(creds);
        Token<?>[] tokens = fs.addDelegationTokens("me", creds);
        Assert.assertEquals((long)1L, (long)tokens.length);
        Assert.assertEquals((Object)fs.getCanonicalServiceName(), (Object)tokens[0].getService().toString());
        Assert.assertTrue((boolean)creds.getAllTokens().contains(tokens[0]));
        Assert.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assert.assertEquals((long)(savedCreds.numberOfTokens() + 1), (long)creds.numberOfTokens());
        savedCreds = new Credentials(creds);
        Token<?>[] tokenRefetch = fs.addDelegationTokens("me", creds);
        Assert.assertEquals((long)0L, (long)tokenRefetch.length);
        Assert.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assert.assertEquals((long)savedCreds.numberOfTokens(), (long)creds.numberOfTokens());
        return tokens;
    }

    static class FakeFileSystem
    extends RawLocalFileSystem {
        URI uri;

        FakeFileSystem() {
        }

        @Override
        public void initialize(URI name, Configuration conf) throws IOException {
            this.uri = name;
        }

        @Override
        public Path getInitialWorkingDirectory() {
            return new Path("/");
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public String getCanonicalServiceName() {
            return String.valueOf(this.getUri() + "/" + this.hashCode());
        }

        @Override
        public Token<?> getDelegationToken(String renewer) throws IOException {
            Token token = new Token();
            token.setService(new Text(this.getCanonicalServiceName()));
            return token;
        }

        @Override
        public void close() {
        }
    }
}

