/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ZooKeeperServer;

public abstract class ActiveStandbyElectorTestUtil {
    private static final Log LOG = LogFactory.getLog(ActiveStandbyElectorTestUtil.class);
    private static final long LOG_INTERVAL_MS = 500L;

    public static void waitForActiveLockData(MultithreadedTestUtil.TestContext ctx, ZooKeeperServer zks, String parentDir, byte[] activeData) throws Exception {
        long st;
        long lastPrint = st = Time.now();
        while (true) {
            block7: {
                if (ctx != null) {
                    ctx.checkException();
                }
                try {
                    Stat stat = new Stat();
                    byte[] data = zks.getZKDatabase().getData(parentDir + "/" + "ActiveStandbyElectorLock", stat, null);
                    if (activeData != null && Arrays.equals(activeData, data)) {
                        return;
                    }
                    if (Time.now() > lastPrint + 500L) {
                        LOG.info((Object)("Cur data: " + StringUtils.byteToHexString(data)));
                        lastPrint = Time.now();
                    }
                }
                catch (KeeperException.NoNodeException nne) {
                    if (activeData == null) {
                        return;
                    }
                    if (Time.now() <= lastPrint + 500L) break block7;
                    LOG.info((Object)"Cur data: no node");
                    lastPrint = Time.now();
                }
            }
            Thread.sleep(50L);
        }
    }

    public static void waitForElectorState(MultithreadedTestUtil.TestContext ctx, ActiveStandbyElector elector, ActiveStandbyElector.State state) throws Exception {
        while (elector.getStateForTests() != state) {
            if (ctx != null) {
                ctx.checkException();
            }
            Thread.sleep(50L);
        }
    }
}

