/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.DummySharedResource;
import org.apache.hadoop.ha.FenceMethod;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.security.AccessControlException;
import org.mockito.Mockito;

class DummyHAService
extends HAServiceTarget {
    public static final Log LOG = LogFactory.getLog(DummyHAService.class);
    private static final String DUMMY_FENCE_KEY = "dummy.fence.key";
    volatile HAServiceProtocol.HAServiceState state;
    HAServiceProtocol proxy;
    ZKFCProtocol zkfcProxy = null;
    NodeFencer fencer;
    InetSocketAddress address;
    boolean isHealthy = true;
    boolean actUnreachable = false;
    boolean failToBecomeActive;
    boolean failToBecomeStandby;
    boolean failToFence;
    DummySharedResource sharedResource;
    public int fenceCount = 0;
    public int activeTransitionCount = 0;
    static ArrayList<DummyHAService> instances = Lists.newArrayList();
    int index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DummyHAService(HAServiceProtocol.HAServiceState state, InetSocketAddress address) {
        this.state = state;
        this.proxy = this.makeMock();
        try {
            Configuration conf = new Configuration();
            conf.set(DUMMY_FENCE_KEY, DummyFencer.class.getName());
            this.fencer = (NodeFencer)Mockito.spy((Object)NodeFencer.create(conf, DUMMY_FENCE_KEY));
        }
        catch (BadFencingConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.address = address;
        ArrayList<DummyHAService> arrayList = instances;
        synchronized (arrayList) {
            instances.add(this);
            this.index = instances.size();
        }
    }

    public void setSharedResource(DummySharedResource rsrc) {
        this.sharedResource = rsrc;
    }

    private HAServiceProtocol makeMock() {
        return (HAServiceProtocol)Mockito.spy((Object)new MockHAProtocolImpl());
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public InetSocketAddress getZKFCAddress() {
        return null;
    }

    @Override
    public HAServiceProtocol getProxy(Configuration conf, int timeout) throws IOException {
        return this.proxy;
    }

    @Override
    public ZKFCProtocol getZKFCProxy(Configuration conf, int timeout) throws IOException {
        assert (this.zkfcProxy != null);
        return this.zkfcProxy;
    }

    @Override
    public NodeFencer getFencer() {
        return this.fencer;
    }

    @Override
    public void checkFencingConfigured() throws BadFencingConfigurationException {
    }

    @Override
    public boolean isAutoFailoverEnabled() {
        return true;
    }

    public String toString() {
        return "DummyHAService #" + this.index;
    }

    public static HAServiceTarget getInstance(int serial) {
        return instances.get(serial - 1);
    }

    public static class DummyFencer
    implements FenceMethod {
        @Override
        public void checkArgs(String args) throws BadFencingConfigurationException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryFence(HAServiceTarget target, String args) throws BadFencingConfigurationException {
            DummyHAService svc;
            LOG.info((Object)("tryFence(" + target + ")"));
            DummyHAService dummyHAService = svc = (DummyHAService)target;
            synchronized (dummyHAService) {
                ++svc.fenceCount;
            }
            if (svc.failToFence) {
                LOG.info((Object)"Injected failure to fence");
                return false;
            }
            svc.sharedResource.release(svc);
            return true;
        }
    }

    private class MockHAProtocolImpl
    implements HAServiceProtocol,
    Closeable {
        private MockHAProtocolImpl() {
        }

        @Override
        public void monitorHealth() throws HealthCheckFailedException, AccessControlException, IOException {
            this.checkUnreachable();
            if (!DummyHAService.this.isHealthy) {
                throw new HealthCheckFailedException("not healthy");
            }
        }

        @Override
        public void transitionToActive(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
            ++DummyHAService.this.activeTransitionCount;
            this.checkUnreachable();
            if (DummyHAService.this.failToBecomeActive) {
                throw new ServiceFailedException("injected failure");
            }
            if (DummyHAService.this.sharedResource != null) {
                DummyHAService.this.sharedResource.take(DummyHAService.this);
            }
            DummyHAService.this.state = HAServiceProtocol.HAServiceState.ACTIVE;
        }

        @Override
        public void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
            this.checkUnreachable();
            if (DummyHAService.this.failToBecomeStandby) {
                throw new ServiceFailedException("injected failure");
            }
            if (DummyHAService.this.sharedResource != null) {
                DummyHAService.this.sharedResource.release(DummyHAService.this);
            }
            DummyHAService.this.state = HAServiceProtocol.HAServiceState.STANDBY;
        }

        @Override
        public HAServiceStatus getServiceStatus() throws IOException {
            this.checkUnreachable();
            HAServiceStatus ret = new HAServiceStatus(DummyHAService.this.state);
            if (DummyHAService.this.state == HAServiceProtocol.HAServiceState.STANDBY) {
                ret.setReadyToBecomeActive();
            }
            return ret;
        }

        private void checkUnreachable() throws IOException {
            if (DummyHAService.this.actUnreachable) {
                throw new IOException("Connection refused (fake)");
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

