/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.junit.Assert;
import org.junit.Test;

public class TestBlocksScheduledCounter {
    @Test
    public void testBlocksScheduledCounter() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(new HdfsConfiguration()).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream out = fs.create(new Path("/testBlockScheduledCounter"));
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        out.hflush();
        ArrayList<DatanodeDescriptor> dnList = new ArrayList<DatanodeDescriptor>();
        DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
        dm.fetchDatanodes(dnList, dnList, false);
        DatanodeDescriptor dn = dnList.get(0);
        Assert.assertEquals((long)1L, (long)dn.getBlocksScheduled());
        out.close();
        Assert.assertEquals((long)0L, (long)dn.getBlocksScheduled());
    }
}

