/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSRename {
    final Path dir = new Path("/test/rename/");

    static int countLease(MiniDFSCluster cluster) {
        return NameNodeAdapter.getLeaseManager(cluster.getNamesystem()).countLease();
    }

    void list(FileSystem fs, String name) throws IOException {
        FileSystem.LOG.info((Object)("\n\n" + name));
        for (FileStatus s : fs.listStatus(this.dir)) {
            FileSystem.LOG.info((Object)("" + s.getPath()));
        }
    }

    static void createFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream a_out = fs.create(f);
        a_out.writeBytes("something");
        ((FilterOutputStream)a_out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path aa = new Path(this.dir, "aa");
            Path b = new Path(this.dir, "b");
            TestDFSRename.createFile(fs, a);
            Assert.assertEquals((long)0L, (long)TestDFSRename.countLease(cluster));
            FSDataOutputStream aa_out = fs.create(aa);
            aa_out.writeBytes("something");
            Assert.assertEquals((long)1L, (long)TestDFSRename.countLease(cluster));
            this.list(fs, "rename0");
            ((FileSystem)fs).rename(a, b);
            this.list(fs, "rename1");
            aa_out.writeBytes(" more");
            ((FilterOutputStream)aa_out).close();
            this.list(fs, "rename2");
            Assert.assertEquals((long)0L, (long)TestDFSRename.countLease(cluster));
            Path dstPath = new Path("/c/d");
            Assert.assertFalse((boolean)fs.exists(dstPath));
            Assert.assertFalse((boolean)((FileSystem)fs).rename(this.dir, dstPath));
            Path src = new Path("/a/b");
            Path dst = new Path("/a/b/c");
            TestDFSRename.createFile(fs, new Path(src, "foo"));
            Assert.assertFalse((boolean)((FileSystem)fs).rename(src, dst));
            Assert.assertFalse((boolean)((FileSystem)fs).rename(src.getParent(), dst.getParent()));
            src = new Path("/testPrefix");
            dst = new Path("/testPrefixfile");
            TestDFSRename.createFile(fs, src);
            Assert.assertTrue((boolean)((FileSystem)fs).rename(src, dst));
            src = new Path("/a/b/c");
            TestDFSRename.createFile(fs, src);
            Assert.assertTrue((boolean)((FileSystem)fs).rename(src, src));
            Assert.assertFalse((boolean)((FileSystem)fs).rename(new Path("/a/b"), new Path("/a/b/")));
            Assert.assertTrue((boolean)((FileSystem)fs).rename(src, new Path("/a/b/c/")));
            ((FileSystem)fs).delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

