/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSStartupVersions {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSStartupVersions");
    private MiniDFSCluster cluster = null;

    void log(String label, HdfsServerConstants.NodeType nodeType, Integer testCase, StorageData sd) {
        String testCaseLine = "";
        if (testCase != null) {
            testCaseLine = " testCase=" + testCase;
        }
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST*** " + label + ":" + testCaseLine + " nodeType=" + (Object)((Object)nodeType) + " layoutVersion=" + sd.storageInfo.getLayoutVersion() + " namespaceID=" + sd.storageInfo.getNamespaceID() + " fsscTime=" + sd.storageInfo.getCTime() + " clusterID=" + sd.storageInfo.getClusterID() + " BlockPoolID=" + sd.blockPoolId));
    }

    private StorageData[] initializeVersions() throws Exception {
        int layoutVersionOld = -16;
        int layoutVersionCur = HdfsConstants.DATANODE_LAYOUT_VERSION;
        int layoutVersionNew = Integer.MIN_VALUE;
        int namespaceIdCur = UpgradeUtilities.getCurrentNamespaceID(null);
        int namespaceIdOld = Integer.MIN_VALUE;
        long fsscTimeOld = Long.MIN_VALUE;
        long fsscTimeCur = UpgradeUtilities.getCurrentFsscTime(null);
        long fsscTimeNew = Long.MAX_VALUE;
        String clusterID = "testClusterID";
        String invalidClusterID = "testClusterID";
        String bpid = UpgradeUtilities.getCurrentBlockPoolID(null);
        String invalidBpid = "invalidBpid";
        return new StorageData[]{new StorageData(layoutVersionOld, namespaceIdCur, clusterID, fsscTimeOld, bpid), new StorageData(layoutVersionOld, namespaceIdCur, clusterID, fsscTimeCur, bpid), new StorageData(layoutVersionOld, namespaceIdCur, clusterID, fsscTimeNew, bpid), new StorageData(layoutVersionOld, namespaceIdOld, clusterID, fsscTimeOld, bpid), new StorageData(layoutVersionOld, namespaceIdOld, clusterID, fsscTimeCur, bpid), new StorageData(layoutVersionOld, namespaceIdOld, clusterID, fsscTimeNew, bpid), new StorageData(layoutVersionCur, namespaceIdCur, clusterID, fsscTimeOld, bpid), new StorageData(layoutVersionCur, namespaceIdCur, clusterID, fsscTimeCur, bpid), new StorageData(layoutVersionCur, namespaceIdCur, clusterID, fsscTimeNew, bpid), new StorageData(layoutVersionCur, namespaceIdOld, clusterID, fsscTimeOld, bpid), new StorageData(layoutVersionCur, namespaceIdOld, clusterID, fsscTimeCur, bpid), new StorageData(layoutVersionCur, namespaceIdOld, clusterID, fsscTimeNew, bpid), new StorageData(layoutVersionNew, namespaceIdCur, clusterID, fsscTimeOld, bpid), new StorageData(layoutVersionNew, namespaceIdCur, clusterID, fsscTimeCur, bpid), new StorageData(layoutVersionNew, namespaceIdCur, clusterID, fsscTimeNew, bpid), new StorageData(layoutVersionNew, namespaceIdOld, clusterID, fsscTimeOld, bpid), new StorageData(layoutVersionNew, namespaceIdOld, clusterID, fsscTimeCur, bpid), new StorageData(layoutVersionNew, namespaceIdOld, clusterID, fsscTimeNew, bpid), new StorageData(layoutVersionCur, namespaceIdCur, invalidClusterID, fsscTimeCur, bpid), new StorageData(layoutVersionCur, namespaceIdCur, clusterID, fsscTimeCur, invalidBpid)};
    }

    boolean isVersionCompatible(StorageData namenodeSd, StorageData datanodeSd) {
        long absStoredLV;
        StorageInfo namenodeVer = namenodeSd.storageInfo;
        StorageInfo datanodeVer = datanodeSd.storageInfo;
        if (namenodeVer.getNamespaceID() != datanodeVer.getNamespaceID()) {
            LOG.info((Object)"namespaceIDs are not equal: isVersionCompatible=false");
            return false;
        }
        if (!namenodeVer.getClusterID().equals(datanodeVer.getClusterID())) {
            LOG.info((Object)"clusterIDs are not equal: isVersionCompatible=false");
            return false;
        }
        if (!namenodeSd.blockPoolId.equals(datanodeSd.blockPoolId)) {
            LOG.info((Object)"blockPoolIDs are not equal: isVersionCompatible=false");
            return false;
        }
        int softwareLV = HdfsConstants.DATANODE_LAYOUT_VERSION;
        int storedLV = datanodeVer.getLayoutVersion();
        if (softwareLV == storedLV && datanodeVer.getCTime() == namenodeVer.getCTime()) {
            LOG.info((Object)"layoutVersions and cTimes are equal: isVersionCompatible=true");
            return true;
        }
        long absSoftwareLV = Math.abs((long)softwareLV);
        if (absSoftwareLV > (absStoredLV = Math.abs((long)storedLV)) || softwareLV == storedLV && datanodeVer.getCTime() < namenodeVer.getCTime()) {
            LOG.info((Object)"softwareLayoutVersion is newer OR namenode cTime is newer: isVersionCompatible=true");
            return true;
        }
        LOG.info((Object)"default case: isVersionCompatible=false");
        return false;
    }

    @Test(timeout=300000L)
    public void testVersions() throws Exception {
        UpgradeUtilities.initialize();
        Configuration conf = UpgradeUtilities.initializeStorageStateConf(1, new HdfsConfiguration());
        StorageData[] versions = this.initializeVersions();
        UpgradeUtilities.createNameNodeStorageDirs(conf.getStrings("dfs.namenode.name.dir"), "current");
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
        StorageData nameNodeVersion = new StorageData(HdfsConstants.NAMENODE_LAYOUT_VERSION, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), UpgradeUtilities.getCurrentFsscTime(this.cluster), UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
        this.log("NameNode version info", HdfsServerConstants.NodeType.NAME_NODE, null, nameNodeVersion);
        String bpid = UpgradeUtilities.getCurrentBlockPoolID(this.cluster);
        for (int i = 0; i < versions.length; ++i) {
            File[] storage = UpgradeUtilities.createDataNodeStorageDirs(conf.getStrings("dfs.datanode.data.dir"), "current");
            this.log("DataNode version info", HdfsServerConstants.NodeType.DATA_NODE, i, versions[i]);
            UpgradeUtilities.createDataNodeVersionFile(storage, versions[i].storageInfo, bpid, versions[i].blockPoolId);
            try {
                this.cluster.startDataNodes(conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            Assert.assertTrue((this.cluster.getNameNode() != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.isVersionCompatible(nameNodeVersion, versions[i]), (Object)this.cluster.isDataNodeUp());
            this.cluster.shutdownDataNodes();
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSStartupVersions().testVersions();
    }

    private static class StorageData {
        private final StorageInfo storageInfo;
        private final String blockPoolId;

        StorageData(int layoutVersion, int namespaceId, String clusterId, long cTime, String bpid) {
            this.storageInfo = new StorageInfo(layoutVersion, namespaceId, clusterId, cTime, HdfsServerConstants.NodeType.DATA_NODE);
            this.blockPoolId = bpid;
        }
    }
}

