/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;

public class TestHDFSFileSystemContract
extends FileSystemContractBaseTest {
    private MiniDFSCluster cluster;
    private String defaultWorkingDirectory;

    protected void setUp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.permissions.umask-mode", "062");
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        this.fs = this.cluster.getFileSystem();
        this.defaultWorkingDirectory = "/user/" + UserGroupInformation.getCurrentUser().getShortUserName();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.cluster.shutdown();
        this.cluster = null;
    }

    @Override
    protected String getDefaultWorkingDirectory() {
        return this.defaultWorkingDirectory;
    }

    public void testAppend() throws IOException {
        AppendTestUtil.testAppend(this.fs, new Path("/testAppend/f"));
    }
}

