/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.collect.HashMultiset;
import org.apache.hadoop.hdfs.PeerCache;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.net.unix.DomainSocket;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestPeerCache {
    static final Log LOG = LogFactory.getLog(TestPeerCache.class);

    @Test
    public void testAddAndRetrieve() throws Exception {
        PeerCache cache = new PeerCache(3, 100000L);
        DatanodeID dnId = new DatanodeID("192.168.0.1", "fakehostname", "fake_datanode_id", 100, 101, 102, 103);
        FakePeer peer = new FakePeer(dnId, false);
        cache.put(dnId, peer);
        Assert.assertTrue((!peer.isClosed() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)peer, (Object)cache.get(dnId, false));
        Assert.assertEquals((long)0L, (long)cache.size());
        cache.close();
    }

    @Test
    public void testExpiry() throws Exception {
        int i;
        int CAPACITY = 3;
        int EXPIRY_PERIOD = 10;
        PeerCache cache = new PeerCache(3, 10L);
        DatanodeID[] dnIds = new DatanodeID[3];
        FakePeer[] peers = new FakePeer[3];
        for (i = 0; i < 3; ++i) {
            dnIds[i] = new DatanodeID("192.168.0.1", "fakehostname_" + i, "fake_datanode_id", 100, 101, 102, 103);
            peers[i] = new FakePeer(dnIds[i], false);
        }
        for (i = 0; i < 3; ++i) {
            cache.put(dnIds[i], peers[i]);
        }
        Thread.sleep(500L);
        Assert.assertEquals((long)0L, (long)cache.size());
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)peers[i].isClosed());
        }
        Thread.sleep(500L);
        cache.close();
    }

    @Test
    public void testEviction() throws Exception {
        int i;
        int CAPACITY = 3;
        PeerCache cache = new PeerCache(3, 100000L);
        DatanodeID[] dnIds = new DatanodeID[4];
        FakePeer[] peers = new FakePeer[4];
        for (i = 0; i < dnIds.length; ++i) {
            dnIds[i] = new DatanodeID("192.168.0.1", "fakehostname_" + i, "fake_datanode_id_" + i, 100, 101, 102, 103);
            peers[i] = new FakePeer(dnIds[i], false);
        }
        for (i = 0; i < 3; ++i) {
            cache.put(dnIds[i], peers[i]);
        }
        Assert.assertEquals((long)3L, (long)cache.size());
        cache.put(dnIds[3], peers[3]);
        Assert.assertEquals((long)3L, (long)cache.size());
        Assert.assertSame(null, (Object)cache.get(dnIds[0], false));
        for (i = 1; i < 3; ++i) {
            Peer peer = cache.get(dnIds[i], false);
            Assert.assertSame((Object)peers[i], (Object)peer);
            Assert.assertTrue((!peer.isClosed() ? 1 : 0) != 0);
            peer.close();
        }
        Assert.assertEquals((long)1L, (long)cache.size());
        cache.close();
    }

    @Test
    public void testMultiplePeersWithSameKey() throws Exception {
        int CAPACITY = 3;
        PeerCache cache = new PeerCache(3, 100000L);
        DatanodeID dnId = new DatanodeID("192.168.0.1", "fakehostname", "fake_datanode_id", 100, 101, 102, 103);
        HashMultiset peers = HashMultiset.create(3);
        for (int i = 0; i < 3; ++i) {
            FakePeer peer = new FakePeer(dnId, false);
            peers.add(peer);
            cache.put(dnId, peer);
        }
        Assert.assertEquals((long)3L, (long)cache.size());
        while (!peers.isEmpty()) {
            Peer peer = cache.get(dnId, false);
            Assert.assertTrue((peer != null ? 1 : 0) != 0);
            Assert.assertTrue((!peer.isClosed() ? 1 : 0) != 0);
            peers.remove(peer);
        }
        Assert.assertEquals((long)0L, (long)cache.size());
        cache.close();
    }

    @Test
    public void testDomainSocketPeers() throws Exception {
        int CAPACITY = 3;
        PeerCache cache = new PeerCache(3, 100000L);
        DatanodeID dnId = new DatanodeID("192.168.0.1", "fakehostname", "fake_datanode_id", 100, 101, 102, 103);
        HashMultiset peers = HashMultiset.create(3);
        for (int i = 0; i < 3; ++i) {
            FakePeer peer = new FakePeer(dnId, i == 2);
            peers.add(peer);
            cache.put(dnId, peer);
        }
        Assert.assertEquals((long)3L, (long)cache.size());
        Peer peer = cache.get(dnId, true);
        Assert.assertTrue((peer.getDomainSocket() != null ? 1 : 0) != 0);
        peers.remove(peer);
        peer = cache.get(dnId, true);
        Assert.assertTrue((peer == null ? 1 : 0) != 0);
        while (!peers.isEmpty()) {
            peer = cache.get(dnId, false);
            Assert.assertTrue((peer != null ? 1 : 0) != 0);
            Assert.assertTrue((!peer.isClosed() ? 1 : 0) != 0);
            peers.remove(peer);
        }
        Assert.assertEquals((long)0L, (long)cache.size());
        cache.close();
    }

    private static class FakePeer
    implements Peer {
        private boolean closed = false;
        private final boolean hasDomain;
        private final DatanodeID dnId;

        public FakePeer(DatanodeID dnId, boolean hasDomain) {
            this.dnId = dnId;
            this.hasDomain = hasDomain;
        }

        @Override
        public ReadableByteChannel getInputStreamChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setReadTimeout(int timeoutMs) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getReceiveBufferSize() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getTcpNoDelay() throws IOException {
            return false;
        }

        @Override
        public void setWriteTimeout(int timeoutMs) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public String getRemoteAddressString() {
            return this.dnId.getInfoAddr();
        }

        @Override
        public String getLocalAddressString() {
            return "127.0.0.1:123";
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        public String toString() {
            return "FakePeer(dnId=" + this.dnId + ")";
        }

        @Override
        public DomainSocket getDomainSocket() {
            if (!this.hasDomain) {
                return null;
            }
            return (DomainSocket)Mockito.mock(DomainSocket.class, (Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    throw new RuntimeException("injected fault.");
                }
            });
        }

        public boolean equals(Object o) {
            if (!(o instanceof FakePeer)) {
                return false;
            }
            FakePeer other = (FakePeer)o;
            return this.hasDomain == other.hasDomain && this.dnId.equals(other.dnId);
        }

        public int hashCode() {
            return this.dnId.hashCode() ^ (this.hasDomain ? 1 : 0);
        }

        @Override
        public boolean hasSecureChannel() {
            return false;
        }
    }
}

