/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestRollingUpgrade;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRollingUpgradeDowngrade {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDowngrade() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = null;
        Path foo = new Path("/foo");
        Path bar = new Path("/bar");
        try {
            cluster = new MiniQJMHACluster.Builder(conf).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.getConfiguration(1).setInt("dfs.ha.tail-edits.period", 1);
            dfsCluster.restartNameNode(1);
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            dfs.mkdirs(foo);
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            dfs.mkdirs(bar);
            TestRollingUpgrade.queryForPreparation(dfs);
            dfs.close();
            dfsCluster.restartNameNode(0, true, "-rollingUpgrade", "downgrade");
            Assert.assertFalse((boolean)dfsCluster.getNamesystem(0).getFSImage().hasRollbackFSImage());
            dfsCluster.shutdownNameNode(1);
            dfsCluster.transitionToActive(0);
            dfs = dfsCluster.getFileSystem(0);
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertTrue((boolean)dfs.exists(bar));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IncorrectVersionException.class)
    public void testRejectNewFsImage() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fs.saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            NNStorage storage = (NNStorage)Mockito.spy((Object)cluster.getNameNode().getFSImage().getStorage());
            int futureVersion = NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION - 1;
            ((NNStorage)Mockito.doReturn((Object)futureVersion).when((Object)storage)).getServiceLayoutVersion();
            storage.writeAll();
            cluster.restartNameNode(0, true, "-rollingUpgrade", "downgrade");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

