/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSnapshotCommands {
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;

    @BeforeClass
    public static void clusterSetUp() throws IOException {
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void clusterShutdown() throws IOException {
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws IOException {
        fs.mkdirs(new Path("/sub1"));
        fs.allowSnapshot(new Path("/sub1"));
        fs.mkdirs(new Path("/sub1/sub1sub1"));
        fs.mkdirs(new Path("/sub1/sub1sub2"));
    }

    @After
    public void tearDown() throws IOException {
        if (fs.exists(new Path("/sub1"))) {
            if (fs.exists(new Path("/sub1/.snapshot"))) {
                for (FileStatus st : fs.listStatus(new Path("/sub1/.snapshot"))) {
                    fs.deleteSnapshot(new Path("/sub1"), st.getPath().getName());
                }
                fs.disallowSnapshot(new Path("/sub1"));
            }
            fs.delete(new Path("/sub1"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolRun(Tool tool, String cmd, int retcode, String contain) throws Exception {
        String[] cmds = StringUtils.split(cmd, ' ');
        System.out.flush();
        System.err.flush();
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        String output = null;
        int ret = 0;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(1024);
            PrintStream out = new PrintStream(bs);
            System.setOut(out);
            System.setErr(out);
            ret = tool.run(cmds);
            System.out.flush();
            System.err.flush();
            out.close();
            output = bs.toString();
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        System.out.println("Output for command: " + cmd + " retcode: " + ret);
        if (output != null) {
            System.out.println(output);
        }
        Assert.assertEquals((long)retcode, (long)ret);
        if (contain != null) {
            Assert.assertTrue((boolean)output.contains(contain));
        }
    }

    private void FsShellRun(String cmd, int retcode, String contain) throws Exception {
        FsShell shell = new FsShell(new Configuration(conf));
        this.toolRun(shell, cmd, retcode, contain);
    }

    private void DFSAdminRun(String cmd, int retcode, String contain) throws Exception {
        DFSAdmin admin = new DFSAdmin(new Configuration(conf));
        this.toolRun(admin, cmd, retcode, contain);
    }

    private void FsShellRun(String cmd) throws Exception {
        this.FsShellRun(cmd, 0, null);
    }

    @Test
    public void testAllowSnapshot() throws Exception {
        this.DFSAdminRun("-allowSnapshot /sub1", 0, "Allowing snaphot on /sub1 succeeded");
        this.FsShellRun("-mkdir /sub2");
        this.DFSAdminRun("-allowSnapshot /sub2", 0, "Allowing snaphot on /sub2 succeeded");
        this.DFSAdminRun("-allowSnapshot /sub3", -1, null);
    }

    @Test
    public void testCreateSnapshot() throws Exception {
        this.FsShellRun("-createSnapshot /sub1 sn0", 0, "Created snapshot /sub1/.snapshot/sn0");
        this.FsShellRun("-createSnapshot /sub1 sn0", 1, "there is already a snapshot with the same name \"sn0\"");
        this.FsShellRun("-rmr /sub1/sub1sub2");
        this.FsShellRun("-mkdir /sub1/sub1sub3");
        this.FsShellRun("-createSnapshot /sub1 sn1", 0, "Created snapshot /sub1/.snapshot/sn1");
        this.FsShellRun("-ls /sub1", 0, "/sub1/sub1sub1");
        this.FsShellRun("-ls /sub1", 0, "/sub1/sub1sub3");
        this.FsShellRun("-ls /sub1/.snapshot", 0, "/sub1/.snapshot/sn0");
        this.FsShellRun("-ls /sub1/.snapshot", 0, "/sub1/.snapshot/sn1");
        this.FsShellRun("-ls /sub1/.snapshot/sn0", 0, "/sub1/.snapshot/sn0/sub1sub1");
        this.FsShellRun("-ls /sub1/.snapshot/sn0", 0, "/sub1/.snapshot/sn0/sub1sub2");
        this.FsShellRun("-ls /sub1/.snapshot/sn1", 0, "/sub1/.snapshot/sn1/sub1sub1");
        this.FsShellRun("-ls /sub1/.snapshot/sn1", 0, "/sub1/.snapshot/sn1/sub1sub3");
    }

    @Test
    public void testMkdirUsingReservedName() throws Exception {
        this.FsShellRun("-ls /");
        this.FsShellRun("-mkdir /.snapshot", 1, "File exists");
        this.FsShellRun("-mkdir /sub1/.snapshot", 1, "File exists");
        this.FsShellRun("-mkdir -p /sub1/.snapshot");
        this.FsShellRun("-mkdir -p /sub1/sub1sub1/.snapshot", 1, "mkdir: \".snapshot\" is a reserved name.");
    }

    @Test
    public void testRenameSnapshot() throws Exception {
        this.FsShellRun("-createSnapshot /sub1 sn.orig");
        this.FsShellRun("-renameSnapshot /sub1 sn.orig sn.rename");
        this.FsShellRun("-ls /sub1/.snapshot", 0, "/sub1/.snapshot/sn.rename");
        this.FsShellRun("-ls /sub1/.snapshot/sn.rename", 0, "/sub1/.snapshot/sn.rename/sub1sub1");
        this.FsShellRun("-ls /sub1/.snapshot/sn.rename", 0, "/sub1/.snapshot/sn.rename/sub1sub2");
    }

    @Test
    public void testDeleteSnapshot() throws Exception {
        this.FsShellRun("-createSnapshot /sub1 sn1");
        this.FsShellRun("-deleteSnapshot /sub1 sn1");
        this.FsShellRun("-deleteSnapshot /sub1 sn1", 1, "deleteSnapshot: Cannot delete snapshot sn1 from path /sub1: the snapshot does not exist.");
    }

    @Test
    public void testDisallowSnapshot() throws Exception {
        this.FsShellRun("-createSnapshot /sub1 sn1");
        this.FsShellRun("-rmr /sub1", 1, "The directory /sub1 cannot be deleted since /sub1 is snapshottable and already has snapshots");
        this.DFSAdminRun("-disallowSnapshot /sub1", -1, "disallowSnapshot: The directory /sub1 has snapshot(s). Please redo the operation after removing all the snapshots.");
        this.FsShellRun("-deleteSnapshot /sub1 sn1");
        this.DFSAdminRun("-disallowSnapshot /sub1", 0, "Disallowing snaphot on /sub1 succeeded");
        this.DFSAdminRun("-disallowSnapshot /sub1", 0, "Disallowing snaphot on /sub1 succeeded");
        this.FsShellRun("-rmr /sub1");
    }
}

