/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDataDirs {
    @Test(timeout=30000L)
    public void testDataDirParsing() throws Throwable {
        Configuration conf = new Configuration();
        File dir0 = new File("/dir0");
        File dir1 = new File("/dir1");
        File dir2 = new File("/dir2");
        File dir3 = new File("/dir3");
        String locations1 = "[disk]/dir0,[DISK]/dir1,[sSd]/dir2,[disK]/dir3";
        conf.set("dfs.datanode.data.dir", locations1);
        List<StorageLocation> locations = DataNode.getStorageLocations(conf);
        Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((Object)locations.get(0).getStorageType()), (Matcher)CoreMatchers.is((Object)((Object)StorageType.DISK)));
        Assert.assertThat((Object)locations.get(0).getUri(), (Matcher)CoreMatchers.is((Object)dir0.toURI()));
        Assert.assertThat((Object)((Object)locations.get(1).getStorageType()), (Matcher)CoreMatchers.is((Object)((Object)StorageType.DISK)));
        Assert.assertThat((Object)locations.get(1).getUri(), (Matcher)CoreMatchers.is((Object)dir1.toURI()));
        Assert.assertThat((Object)((Object)locations.get(2).getStorageType()), (Matcher)CoreMatchers.is((Object)((Object)StorageType.SSD)));
        Assert.assertThat((Object)locations.get(2).getUri(), (Matcher)CoreMatchers.is((Object)dir2.toURI()));
        Assert.assertThat((Object)((Object)locations.get(3).getStorageType()), (Matcher)CoreMatchers.is((Object)((Object)StorageType.DISK)));
        Assert.assertThat((Object)locations.get(3).getUri(), (Matcher)CoreMatchers.is((Object)dir3.toURI()));
        String locations2 = "[BadMediaType]/dir0,[ssd]/dir1,[disk]/dir2";
        conf.set("dfs.datanode.data.dir", locations2);
        try {
            locations = DataNode.getStorageLocations(conf);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            DataNode.LOG.info((Object)"The exception is expected.", (Throwable)iae);
        }
        String locations3 = "/dir0,/dir1";
        conf.set("dfs.datanode.data.dir", locations3);
        locations = DataNode.getStorageLocations(conf);
        Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Object)locations.get(0).getStorageType()), (Matcher)CoreMatchers.is((Object)((Object)StorageType.DISK)));
        Assert.assertThat((Object)locations.get(0).getUri(), (Matcher)CoreMatchers.is((Object)dir0.toURI()));
        Assert.assertThat((Object)((Object)locations.get(1).getStorageType()), (Matcher)CoreMatchers.is((Object)((Object)StorageType.DISK)));
        Assert.assertThat((Object)locations.get(1).getUri(), (Matcher)CoreMatchers.is((Object)dir1.toURI()));
    }

    @Test(timeout=30000L)
    public void testDataDirValidation() throws Throwable {
        DataNode.DataNodeDiskChecker diskChecker = (DataNode.DataNodeDiskChecker)Mockito.mock(DataNode.DataNodeDiskChecker.class);
        ((DataNode.DataNodeDiskChecker)Mockito.doThrow((Throwable)new IOException()).doThrow((Throwable)new IOException()).doNothing().when((Object)diskChecker)).checkDir((LocalFileSystem)Mockito.any(LocalFileSystem.class), (Path)Mockito.any(Path.class));
        LocalFileSystem fs = (LocalFileSystem)Mockito.mock(LocalFileSystem.class);
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        ((AbstractList)locations).add(StorageLocation.parse("file:/p1/"));
        ((AbstractList)locations).add(StorageLocation.parse("file:/p2/"));
        ((AbstractList)locations).add(StorageLocation.parse("file:/p3/"));
        List<StorageLocation> checkedLocations = DataNode.checkStorageLocations(locations, fs, diskChecker);
        Assert.assertEquals((String)"number of valid data dirs", (long)1L, (long)checkedLocations.size());
        String validDir = checkedLocations.iterator().next().getFile().getPath();
        Assert.assertThat((String)"p3 should be valid", (Object)new File("/p3/").getPath(), (Matcher)CoreMatchers.is((Object)validDir));
    }
}

