/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.ArrayList;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeMetrics {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory(conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            long LONG_FILE_LEN = 0x80000000L;
            DFSTestUtil.createFile(fs, new Path("/tmp.txt"), 0x80000000L, (short)1, 1L);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics(datanode.getMetrics().name());
            MetricsAsserts.assertCounter("BytesWritten", 0x80000000L, rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendDataPacketMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean interval = true;
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path tmpfile = new Path("/tmp.txt");
            DFSTestUtil.createFile(fs, tmpfile, 1L, (short)1, 1L);
            DFSTestUtil.readFile(fs, tmpfile);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics(datanode.getMetrics().name());
            MetricsAsserts.assertCounter("SendDataPacketTransferNanosNumOps", 2L, rb);
            MetricsAsserts.assertCounter("SendDataPacketBlockedOnNetworkNanosNumOps", 2L, rb);
            Thread.sleep(2000L);
            String sec = "1s";
            MetricsAsserts.assertQuantileGauges("SendDataPacketBlockedOnNetworkNanos" + sec, rb);
            MetricsAsserts.assertQuantileGauges("SendDataPacketTransferNanos" + sec, rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceivePacketMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean interval = true;
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testFlushNanosMetric.txt");
            FSDataOutputStream fout = fs.create(testFile);
            fout.write(new byte[1]);
            fout.hsync();
            fout.close();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics(datanode.getMetrics().name());
            MetricsAsserts.assertCounter("FlushNanosNumOps", 2L, dnMetrics);
            MetricsAsserts.assertCounter("FsyncNanosNumOps", 2L, dnMetrics);
            Thread.sleep(2000L);
            String sec = "1s";
            MetricsAsserts.assertQuantileGauges("FlushNanos" + sec, dnMetrics);
            MetricsAsserts.assertQuantileGauges("FsyncNanos" + sec, dnMetrics);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoundTripAckMetric() throws Exception {
        int datanodeCount = 2;
        boolean interval = true;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testRoundTripAckMetric.txt");
            FSDataOutputStream fsout = fs.create(testFile, (short)2);
            DFSOutputStream dout = (DFSOutputStream)fsout.getWrappedStream();
            dout.setChunksPerPacket(5);
            dout.setArtificialSlowdown(3000L);
            fsout.write(new byte[10000]);
            DatanodeInfo[] pipeline = null;
            for (int count = 0; pipeline == null && count < 5; ++count) {
                pipeline = dout.getPipeline();
                System.out.println("Waiting for pipeline to be created.");
                Thread.sleep(1000L);
            }
            void headInfo = pipeline[0];
            DataNode headNode = null;
            for (DataNode datanode : cluster.getDataNodes()) {
                if (!datanode.getDatanodeId().equals(headInfo)) continue;
                headNode = datanode;
                break;
            }
            Assert.assertNotNull((String)"Could not find the head of the datanode write pipeline", headNode);
            Thread.sleep(2000L);
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics(headNode.getMetrics().name());
            Assert.assertTrue((String)"Expected non-zero number of acks", (MetricsAsserts.getLongCounter("PacketAckRoundTripTimeNanosNumOps", dnMetrics) > 0L ? 1 : 0) != 0);
            MetricsAsserts.assertQuantileGauges("PacketAckRoundTripTimeNanos1s", dnMetrics);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

