/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.FsAclPermission;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class FSAclBaseTest {
    private static final UserGroupInformation BRUCE = UserGroupInformation.createUserForTesting("bruce", new String[0]);
    private static final UserGroupInformation DIANA = UserGroupInformation.createUserForTesting("diana", new String[0]);
    private static final UserGroupInformation SUPERGROUP_MEMBER = UserGroupInformation.createUserForTesting("super", new String[]{"supergroup"});
    protected static MiniDFSCluster cluster;
    protected static Configuration conf;
    private static int pathCount;
    private static Path path;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private FileSystem fs;
    private FileSystem fsAsBruce;
    private FileSystem fsAsDiana;
    private FileSystem fsAsSupergroupMember;

    @AfterClass
    public static void shutdown() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        path = new Path("/p" + ++pathCount);
        this.initFileSystems();
    }

    @After
    public void destroyFileSystems() {
        IOUtils.cleanup(null, this.fs, this.fsAsBruce, this.fsAsDiana, this.fsAsSupergroupMember);
        this.fsAsSupergroupMember = null;
        this.fsAsDiana = null;
        this.fsAsBruce = null;
        this.fs = null;
    }

    @Test
    public void testModifyAclEntries() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE));
        this.fs.modifyAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE));
        this.fs.modifyAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE));
        this.fs.modifyAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE));
        this.fs.modifyAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4528);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE));
        this.fs.modifyAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesCustomMask() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE));
        this.fs.modifyAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testModifyAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)1000));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE));
        this.fs.modifyAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testModifyAclEntriesPathNotFound() throws IOException {
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.modifyAclEntries(path, aclSpec);
    }

    @Test(expected=AclException.class)
    public void testModifyAclEntriesDefaultOnFile() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.modifyAclEntries(path, aclSpec);
    }

    @Test
    public void testRemoveAclEntries() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo"));
        this.fs.removeAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"));
        this.fs.removeAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE)}, (Object[])returned);
        this.assertPermission((short)4592);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesOnlyDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo"));
        this.fs.removeAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)496));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK));
        this.fs.removeAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)496);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclEntriesMinimalDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK));
        this.fs.removeAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveAclEntriesStickyBit() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)1000));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo"));
        this.fs.removeAclEntries(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)5096);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclEntriesPathNotFound() throws IOException {
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"));
        this.fs.removeAclEntries(path, aclSpec);
    }

    @Test
    public void testRemoveDefaultAcl() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveDefaultAclOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testRemoveDefaultAclOnlyDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveDefaultAclMinimal() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveDefaultAclStickyBit() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)1000));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.removeDefaultAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveDefaultAclPathNotFound() throws IOException {
        this.fs.removeDefaultAcl(path);
    }

    @Test
    public void testRemoveAcl() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclMinimalAcl() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclStickyBit() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)1000));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)1000);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testRemoveAclOnlyDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.removeAcl(path);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)488);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclPathNotFound() throws IOException {
        this.fs.removeAcl(path);
    }

    @Test
    public void testSetAcl() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4600);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4512);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclOnlyDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclMinimal() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)420));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((short)416);
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testSetAclMinimalDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4584);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclCustomMask() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4536);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetAclStickyBit() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)1000));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)5112);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSetAclPathNotFound() throws IOException {
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
    }

    @Test(expected=AclException.class)
    public void testSetAclDefaultOnFile() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
    }

    @Test
    public void testSetPermission() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyAccess() throws IOException {
        this.fs.create(path).close();
        this.fs.setPermission(path, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)384));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        this.assertPermission((short)4480);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionOnlyDefault() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        AclStatus s = this.fs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission((short)4544);
        FSAclBaseTest.assertAclFeature(true);
    }

    @Test
    public void testSetPermissionCannotSetAclBit() throws IOException {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        this.fs.setPermission(path, FsPermission.createImmutable((short)448));
        this.assertPermission((short)448);
        this.fs.setPermission(path, new FsAclPermission(FsPermission.createImmutable((short)493)));
        INode inode = cluster.getNamesystem().getFSDirectory().getRoot().getNode(path.toUri().getPath(), false);
        Assert.assertNotNull((Object)inode);
        FsPermission perm = inode.getFsPermission();
        Assert.assertNotNull((Object)perm);
        Assert.assertEquals((long)493L, (long)perm.toShort());
        Assert.assertEquals((long)493L, (long)perm.toExtendedShort());
        FSAclBaseTest.assertAclFeature(false);
    }

    @Test
    public void testDefaultAclNewFile() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(filePath, (short)4512);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testOnlyAccessAclNewFile() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.modifyAclEntries(path, aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(filePath, (short)420);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultMinimalAclNewFile() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(filePath, (short)416);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultAclNewDir() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testOnlyAccessAclNewDir() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.modifyAclEntries(path, aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission(dirPath, (short)493);
        FSAclBaseTest.assertAclFeature(dirPath, false);
    }

    @Test
    public void testDefaultMinimalAclNewDir() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE));
        this.fs.setAcl(path, aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath);
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testDefaultAclNewFileIntermediate() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path filePath = new Path(dirPath, "file1");
        this.fs.create(filePath).close();
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        s = this.fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(filePath, (short)4512);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirIntermediate() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path subdirPath = new Path(dirPath, "subdir1");
        this.fs.mkdirs(subdirPath);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        s = this.fs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(subdirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(subdirPath, true);
    }

    @Test
    public void testDefaultAclNewSymlinkIntermediate() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)488));
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        this.fs.setPermission(filePath, FsPermission.createImmutable((short)416));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        Path dirPath = new Path(path, "dir1");
        Path linkPath = new Path(dirPath, "link1");
        this.fs.createSymlink(filePath, linkPath, true);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(dirPath, (short)4584);
        FSAclBaseTest.assertAclFeature(dirPath, true);
        expected = new AclEntry[]{};
        s = this.fs.getAclStatus(linkPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(linkPath, (short)416);
        FSAclBaseTest.assertAclFeature(linkPath, false);
        s = this.fs.getAclStatus(filePath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(filePath, (short)416);
        FSAclBaseTest.assertAclFeature(filePath, false);
    }

    @Test
    public void testDefaultAclNewFileWithMode() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)493));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        Path filePath = new Path(path, "file1");
        int bufferSize = cluster.getConfiguration(0).getInt("io.file.buffer.size", 4096);
        this.fs.create(filePath, new FsPermission(480), false, bufferSize, this.fs.getDefaultReplication(filePath), this.fs.getDefaultBlockSize(path), null).close();
        AclStatus s = this.fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(filePath, (short)4576);
        FSAclBaseTest.assertAclFeature(filePath, true);
    }

    @Test
    public void testDefaultAclNewDirWithMode() throws Exception {
        FileSystem.mkdirs(this.fs, path, FsPermission.createImmutable((short)493));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(path, aclSpec);
        Path dirPath = new Path(path, "dir1");
        this.fs.mkdirs(dirPath, new FsPermission(480));
        AclStatus s = this.fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)}, (Object[])returned);
        this.assertPermission(dirPath, (short)4576);
        FSAclBaseTest.assertAclFeature(dirPath, true);
    }

    @Test
    public void testDefaultAclRenamedFile() throws Exception {
        Path dirPath = new Path(path, "dir");
        FileSystem.mkdirs(this.fs, dirPath, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(dirPath, aclSpec);
        Path filePath = new Path(path, "file1");
        this.fs.create(filePath).close();
        this.fs.setPermission(filePath, FsPermission.createImmutable((short)416));
        Path renamedFilePath = new Path(dirPath, "file1");
        this.fs.rename(filePath, renamedFilePath);
        Object[] expected = new AclEntry[]{};
        AclStatus s = this.fs.getAclStatus(renamedFilePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(renamedFilePath, (short)416);
        FSAclBaseTest.assertAclFeature(renamedFilePath, false);
    }

    @Test
    public void testDefaultAclRenamedDir() throws Exception {
        Path dirPath = new Path(path, "dir");
        FileSystem.mkdirs(this.fs, dirPath, FsPermission.createImmutable((short)488));
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        this.fs.setAcl(dirPath, aclSpec);
        Path subdirPath = new Path(path, "subdir");
        FileSystem.mkdirs(this.fs, subdirPath, FsPermission.createImmutable((short)488));
        Path renamedSubdirPath = new Path(dirPath, "subdir");
        this.fs.rename(subdirPath, renamedSubdirPath);
        Object[] expected = new AclEntry[]{};
        AclStatus s = this.fs.getAclStatus(renamedSubdirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission(renamedSubdirPath, (short)488);
        FSAclBaseTest.assertAclFeature(renamedSubdirPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipAclEnforcementPermsDisabled() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.modifyAclEntries(bruceFile, Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE)));
        AclTestHelpers.assertFilePermissionDenied(this.fsAsDiana, DIANA, bruceFile);
        try {
            conf.setBoolean("dfs.permissions.enabled", false);
            this.destroyFileSystems();
            this.restartCluster();
            this.initFileSystems();
            AclTestHelpers.assertFilePermissionGranted(this.fsAsDiana, DIANA, bruceFile);
        }
        finally {
            conf.setBoolean("dfs.permissions.enabled", true);
            this.restartCluster();
        }
    }

    @Test
    public void testSkipAclEnforcementSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.modifyAclEntries(bruceFile, Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE)));
        AclTestHelpers.assertFilePermissionGranted(this.fs, DIANA, bruceFile);
        AclTestHelpers.assertFilePermissionGranted(this.fsAsBruce, DIANA, bruceFile);
        AclTestHelpers.assertFilePermissionDenied(this.fsAsDiana, DIANA, bruceFile);
        AclTestHelpers.assertFilePermissionGranted(this.fsAsSupergroupMember, SUPERGROUP_MEMBER, bruceFile);
    }

    @Test
    public void testModifyAclEntriesMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.ALL));
        this.fsAsBruce.modifyAclEntries(bruceFile, aclSpec);
        this.fs.modifyAclEntries(bruceFile, aclSpec);
        this.fsAsSupergroupMember.modifyAclEntries(bruceFile, aclSpec);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.modifyAclEntries(bruceFile, aclSpec);
    }

    @Test
    public void testRemoveAclEntriesMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana"));
        this.fsAsBruce.removeAclEntries(bruceFile, aclSpec);
        this.fs.removeAclEntries(bruceFile, aclSpec);
        this.fsAsSupergroupMember.removeAclEntries(bruceFile, aclSpec);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.removeAclEntries(bruceFile, aclSpec);
    }

    @Test
    public void testRemoveDefaultAclMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.removeDefaultAcl(bruceFile);
        this.fs.removeDefaultAcl(bruceFile);
        this.fsAsSupergroupMember.removeDefaultAcl(bruceFile);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.removeDefaultAcl(bruceFile);
    }

    @Test
    public void testRemoveAclMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.removeAcl(bruceFile);
        this.fs.removeAcl(bruceFile);
        this.fsAsSupergroupMember.removeAcl(bruceFile);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.removeAcl(bruceFile);
    }

    @Test
    public void testSetAclMustBeOwnerOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.fsAsBruce.setAcl(bruceFile, aclSpec);
        this.fs.setAcl(bruceFile, aclSpec);
        this.fsAsSupergroupMember.setAcl(bruceFile, aclSpec);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.setAcl(bruceFile, aclSpec);
    }

    @Test
    public void testGetAclStatusRequiresTraverseOrSuper() throws Exception {
        Path bruceDir = new Path(path, "bruce");
        Path bruceFile = new Path(bruceDir, "file");
        this.fs.mkdirs(bruceDir);
        this.fs.setOwner(bruceDir, "bruce", null);
        this.fsAsBruce.create(bruceFile).close();
        this.fsAsBruce.setAcl(bruceDir, Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)));
        this.fsAsBruce.getAclStatus(bruceFile);
        this.fs.getAclStatus(bruceFile);
        this.fsAsSupergroupMember.getAclStatus(bruceFile);
        this.exception.expect(AccessControlException.class);
        this.fsAsDiana.getAclStatus(bruceFile);
    }

    protected FileSystem createFileSystem() throws Exception {
        return cluster.getFileSystem();
    }

    protected FileSystem createFileSystem(UserGroupInformation user) throws Exception {
        return DFSTestUtil.getFileSystemAs(user, cluster.getConfiguration(0));
    }

    private void initFileSystems() throws Exception {
        this.fs = this.createFileSystem();
        this.fsAsBruce = this.createFileSystem(BRUCE);
        this.fsAsDiana = this.createFileSystem(DIANA);
        this.fsAsSupergroupMember = this.createFileSystem(SUPERGROUP_MEMBER);
    }

    private void restartCluster() throws Exception {
        FSAclBaseTest.shutdown();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(false).build();
        cluster.waitActive();
    }

    private static void assertAclFeature(boolean expectAclFeature) throws IOException {
        FSAclBaseTest.assertAclFeature(path, expectAclFeature);
    }

    private static void assertAclFeature(Path pathToCheck, boolean expectAclFeature) throws IOException {
        INode inode = cluster.getNamesystem().getFSDirectory().getRoot().getNode(pathToCheck.toUri().getPath(), false);
        Assert.assertNotNull((Object)inode);
        AclFeature aclFeature = inode.getAclFeature();
        if (expectAclFeature) {
            Assert.assertNotNull((Object)aclFeature);
            ImmutableList<AclEntry> entries = aclFeature.getEntries();
            Assert.assertNotNull(entries);
            Assert.assertFalse((boolean)entries.isEmpty());
        } else {
            Assert.assertNull((Object)aclFeature);
        }
    }

    private void assertPermission(short perm) throws IOException {
        this.assertPermission(path, perm);
    }

    private void assertPermission(Path pathToCheck, short perm) throws IOException {
        AclTestHelpers.assertPermission(this.fs, pathToCheck, perm);
    }

    static {
        pathCount = 0;
    }
}

