/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;

public class TestCheckPointForSecurityTokens {
    static final long seed = 3735928559L;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    static final int numDatanodes = 3;
    short replication = (short)3;
    MiniDFSCluster cluster = null;

    private void cancelToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.cluster.getNamesystem().cancelDelegationToken(token);
    }

    private void renewToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.cluster.getNamesystem().renewDelegationToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveNamespace() throws IOException {
        DistributedFileSystem fs = null;
        try {
            long numTransactions;
            FileJournalManager.EditLogFile log;
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            this.cluster.waitActive();
            fs = this.cluster.getFileSystem();
            FSNamesystem namesystem = this.cluster.getNamesystem();
            String renewer = UserGroupInformation.getLoginUser().getUserName();
            Token<DelegationTokenIdentifier> token1 = namesystem.getDelegationToken(new Text(renewer));
            Token<DelegationTokenIdentifier> token2 = namesystem.getDelegationToken(new Text(renewer));
            DFSAdmin admin = new DFSAdmin(conf);
            String[] args = new String[]{"-saveNamespace"};
            NameNode nn = this.cluster.getNameNode();
            for (Storage.StorageDirectory sd : nn.getFSImage().getStorage().dirIterable(null)) {
                log = FSImageTestUtil.findLatestEditsLog(sd);
                Assert.assertTrue((boolean)log.isInProgress());
                log.validateLog();
                numTransactions = log.getLastTxId() - log.getFirstTxId() + 1L;
                Assert.assertEquals((String)("In-progress log " + log + " should have 5 transactions"), (long)5L, (long)numTransactions);
            }
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                admin.run(args);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            for (Storage.StorageDirectory sd : nn.getFSImage().getStorage().dirIterable(null)) {
                log = FSImageTestUtil.findLatestEditsLog(sd);
                Assert.assertTrue((boolean)log.isInProgress());
                log.validateLog();
                numTransactions = log.getLastTxId() - log.getFirstTxId() + 1L;
                Assert.assertEquals((String)("In-progress log " + log + " should only have START txn"), (long)1L, (long)numTransactions);
            }
            this.cluster.shutdown();
            this.cluster = null;
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(false).build();
            this.cluster.waitActive();
            try {
                this.renewToken(token1);
                this.renewToken(token2);
            }
            catch (IOException e) {
                Assert.fail((String)"Could not renew or cancel the token");
            }
            namesystem = this.cluster.getNamesystem();
            Token<DelegationTokenIdentifier> token3 = namesystem.getDelegationToken(new Text(renewer));
            Token<DelegationTokenIdentifier> token4 = namesystem.getDelegationToken(new Text(renewer));
            this.cluster.shutdown();
            this.cluster = null;
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(false).build();
            this.cluster.waitActive();
            namesystem = this.cluster.getNamesystem();
            Token<DelegationTokenIdentifier> token5 = namesystem.getDelegationToken(new Text(renewer));
            try {
                this.renewToken(token1);
                this.renewToken(token2);
                this.renewToken(token3);
                this.renewToken(token4);
                this.renewToken(token5);
            }
            catch (IOException e) {
                Assert.fail((String)"Could not renew or cancel the token");
            }
            this.cluster.shutdown();
            this.cluster = null;
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(false).build();
            this.cluster.waitActive();
            namesystem = this.cluster.getNamesystem();
            try {
                this.renewToken(token1);
                this.cancelToken(token1);
                this.renewToken(token2);
                this.cancelToken(token2);
                this.renewToken(token3);
                this.cancelToken(token3);
                this.renewToken(token4);
                this.cancelToken(token4);
                this.renewToken(token5);
                this.cancelToken(token5);
            }
            catch (IOException e) {
                Assert.fail((String)"Could not renew or cancel the token");
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }
}

