/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.EditsDoubleBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestEditsDoubleBuffer {
    @Test
    public void testDoubleBuffer() throws IOException {
        EditsDoubleBuffer buf = new EditsDoubleBuffer(1024);
        Assert.assertTrue((boolean)buf.isFlushed());
        byte[] data = new byte[100];
        buf.writeRaw(data, 0, data.length);
        Assert.assertEquals((String)"Should count new data correctly", (long)data.length, (long)buf.countBufferedBytes());
        Assert.assertTrue((String)"Writing to current buffer should not affect flush state", (boolean)buf.isFlushed());
        buf.setReadyToFlush();
        Assert.assertEquals((String)"Swapping buffers should still count buffered bytes", (long)data.length, (long)buf.countBufferedBytes());
        Assert.assertFalse((boolean)buf.isFlushed());
        DataOutputBuffer outBuf = new DataOutputBuffer();
        buf.flushTo(outBuf);
        Assert.assertEquals((long)data.length, (long)outBuf.getLength());
        Assert.assertTrue((boolean)buf.isFlushed());
        Assert.assertEquals((long)0L, (long)buf.countBufferedBytes());
        buf.writeRaw(data, 0, data.length);
        Assert.assertEquals((String)"Should count new data correctly", (long)data.length, (long)buf.countBufferedBytes());
        buf.setReadyToFlush();
        buf.flushTo(outBuf);
        Assert.assertEquals((long)(data.length * 2), (long)outBuf.getLength());
        Assert.assertEquals((long)0L, (long)buf.countBufferedBytes());
        outBuf.close();
    }

    @Test
    public void shouldFailToCloseWhenUnflushed() throws IOException {
        block2: {
            EditsDoubleBuffer buf = new EditsDoubleBuffer(1024);
            buf.writeRaw(new byte[1], 0, 1);
            try {
                buf.close();
                Assert.fail((String)"Did not fail to close with unflushed data");
            }
            catch (IOException ioe) {
                if (ioe.toString().contains("still to be flushed")) break block2;
                throw ioe;
            }
        }
    }
}

