/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.Assert;
import org.junit.Test;

public class TestFSImageStorageInspector {
    @Test
    public void testCurrentStorageInspector() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        Storage.StorageDirectory mockDir = FSImageTestUtil.mockStorageDirectory(NNStorage.NameNodeDirType.IMAGE_AND_EDITS, false, "/foo/current/" + NNStorage.getImageFileName(123L), "/foo/current/" + NNStorage.getFinalizedEditsFileName(123L, 456L), "/foo/current/" + NNStorage.getImageFileName(456L), "/foo/current/" + NNStorage.getInProgressEditsFileName(457L));
        inspector.inspectDirectory(mockDir);
        Assert.assertEquals((long)2L, (long)inspector.foundImages.size());
        FSImageStorageInspector.FSImageFile latestImage = inspector.getLatestImages().get(0);
        Assert.assertEquals((long)456L, (long)latestImage.txId);
        Assert.assertSame((Object)mockDir, (Object)latestImage.sd);
        Assert.assertTrue((boolean)inspector.isUpgradeFinalized());
        Assert.assertEquals((Object)new File("/foo/current/" + NNStorage.getImageFileName(456L)), (Object)latestImage.getFile());
    }
}

