/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestFsLimits {
    static Configuration conf;
    static INode[] inodes;
    static FSDirectory fs;
    static boolean fsIsReady;
    static final PermissionStatus perms;

    private static FSImage getMockFSImage() {
        FSEditLog editLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)editLog);
        return fsImage;
    }

    private static FSNamesystem getMockNamesystem() {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.createFsOwnerPermissions((FsPermission)Matchers.anyObject())).thenReturn((Object)new PermissionStatus("root", "wheel", FsPermission.getDefault()));
        return fsn;
    }

    @Before
    public void setUp() throws IOException {
        conf = new Configuration();
        conf.set("dfs.namenode.name.dir", Util.fileAsURI(new File(MiniDFSCluster.getBaseDirectory(), "namenode")).toString());
        fs = null;
        fsIsReady = true;
    }

    @Test
    public void testNoLimits() throws Exception {
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", null);
        this.mkdirs("/4444", null);
        this.mkdirs("/55555", null);
        this.mkdirs("/1/.snapshot", HadoopIllegalArgumentException.class);
    }

    @Test
    public void testMaxComponentLength() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.PathComponentTooLongException.class);
        this.mkdirs("/4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testMaxComponentLengthRename() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 2);
        this.mkdirs("/5", null);
        this.rename("/5", "/555", FSLimitException.PathComponentTooLongException.class);
        this.rename("/5", "/55", null);
        this.mkdirs("/6", null);
        this.deprecatedRename("/6", "/666", FSLimitException.PathComponentTooLongException.class);
        this.deprecatedRename("/6", "/66", null);
    }

    @Test
    public void testMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.mkdirs("/4444", FSLimitException.MaxDirectoryItemsExceededException.class);
    }

    @Test
    public void testMaxDirItemsRename() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/2", null);
        this.mkdirs("/2/A", null);
        this.rename("/2/A", "/A", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.rename("/2/A", "/1/A", null);
        this.mkdirs("/2/B", null);
        this.deprecatedRename("/2/B", "/B", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.deprecatedRename("/2/B", "/1/B", null);
        this.rename("/1", "/3", null);
        this.deprecatedRename("/2", "/4", null);
    }

    @Test
    public void testMaxDirItemsLimits() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 0);
        try {
            this.mkdirs("1", null);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Cannot set dfs", e);
        }
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 0x640000);
        try {
            this.mkdirs("1", null);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Cannot set dfs", e);
        }
    }

    @Test
    public void testMaxComponentsAndMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.mkdirs("/4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testDuringEditLogs() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        fsIsReady = false;
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", null);
        this.mkdirs("/4444", null);
        this.mkdirs("/1/.snapshot", HadoopIllegalArgumentException.class);
    }

    private void mkdirs(String name, Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        Class<?> generated = null;
        try {
            fs.mkdirs(name, perms, false, Time.now());
        }
        catch (Throwable e) {
            generated = e.getClass();
        }
        Assert.assertEquals(expected, generated);
    }

    private void rename(String src, String dst, Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        Class<?> generated = null;
        try {
            fs.renameTo(src, dst, false, new Options.Rename[0]);
        }
        catch (Throwable e) {
            generated = e.getClass();
        }
        Assert.assertEquals(expected, generated);
    }

    private void deprecatedRename(String src, String dst, Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        Class<?> generated = null;
        try {
            fs.renameTo(src, dst, false);
        }
        catch (Throwable e) {
            generated = e.getClass();
        }
        Assert.assertEquals(expected, generated);
    }

    private static void lazyInitFSDirectory() throws IOException {
        if (fs == null) {
            fs = new MockFSDirectory();
        }
    }

    static {
        perms = new PermissionStatus("admin", "admin", FsPermission.getDefault());
    }

    private static class MockFSDirectory
    extends FSDirectory {
        public MockFSDirectory() throws IOException {
            super(TestFsLimits.getMockFSImage(), TestFsLimits.getMockNamesystem(), conf);
            this.setReady(fsIsReady);
            NameNode.initMetrics(conf, HdfsServerConstants.NamenodeRole.NAMENODE);
        }
    }
}

