/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeOptionParsing {
    @Test(timeout=10000L)
    public void testUpgrade() {
        HdfsServerConstants.StartupOption opt = null;
        opt = NameNode.parseArguments(new String[]{"-upgrade"});
        Assert.assertEquals((Object)((Object)opt), (Object)((Object)HdfsServerConstants.StartupOption.UPGRADE));
        Assert.assertNull((Object)opt.getClusterId());
        Assert.assertTrue((boolean)FSImageFormat.renameReservedMap.isEmpty());
        opt = NameNode.parseArguments(new String[]{"-upgrade", "-clusterid", "mycid"});
        Assert.assertEquals((Object)((Object)HdfsServerConstants.StartupOption.UPGRADE), (Object)((Object)opt));
        Assert.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assert.assertTrue((boolean)FSImageFormat.renameReservedMap.isEmpty());
        opt = NameNode.parseArguments(new String[]{"-upgrade", "-clusterid", "mycid", "-renameReserved", ".snapshot=.my-snapshot,.reserved=.my-reserved"});
        Assert.assertEquals((Object)((Object)HdfsServerConstants.StartupOption.UPGRADE), (Object)((Object)opt));
        Assert.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assert.assertEquals((Object)".my-snapshot", (Object)FSImageFormat.renameReservedMap.get(".snapshot"));
        Assert.assertEquals((Object)".my-reserved", (Object)FSImageFormat.renameReservedMap.get(".reserved"));
        FSImageFormat.renameReservedMap.clear();
        opt = NameNode.parseArguments(new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.snapshot=.my-snapshot", "-clusterid", "mycid"});
        Assert.assertEquals((Object)((Object)HdfsServerConstants.StartupOption.UPGRADE), (Object)((Object)opt));
        Assert.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assert.assertEquals((Object)".my-snapshot", (Object)FSImageFormat.renameReservedMap.get(".snapshot"));
        Assert.assertEquals((Object)".my-reserved", (Object)FSImageFormat.renameReservedMap.get(".reserved"));
        opt = NameNode.parseArguments(new String[]{"-upgrade", "-renameReserved"});
        Assert.assertEquals((Object)((Object)HdfsServerConstants.StartupOption.UPGRADE), (Object)((Object)opt));
        Assert.assertEquals((Object)(".snapshot." + HdfsConstants.NAMENODE_LAYOUT_VERSION + ".UPGRADE_RENAMED"), (Object)FSImageFormat.renameReservedMap.get(".snapshot"));
        Assert.assertEquals((Object)(".reserved." + HdfsConstants.NAMENODE_LAYOUT_VERSION + ".UPGRADE_RENAMED"), (Object)FSImageFormat.renameReservedMap.get(".reserved"));
        try {
            opt = NameNode.parseArguments(new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.not-reserved=.my-not-reserved"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Unknown reserved path", e);
        }
        try {
            opt = NameNode.parseArguments(new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.snapshot=.snapshot"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Invalid rename path", e);
        }
        try {
            opt = NameNode.parseArguments(new String[]{"-upgrade", "-renameReserved", ".snapshot=.reserved"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Invalid rename path", e);
        }
        opt = NameNode.parseArguments(new String[]{"-upgrade", "-cid"});
        Assert.assertNull((Object)((Object)opt));
    }
}

