/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.hdfs.server.namenode.StartupProgressServlet;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressTestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mortbay.util.ajax.JSON;

public class TestStartupProgressServlet {
    private HttpServletRequest req;
    private HttpServletResponse resp;
    private ByteArrayOutputStream respOut;
    private StartupProgress startupProgress;
    private StartupProgressServlet servlet;

    @Before
    public void setUp() throws Exception {
        this.startupProgress = new StartupProgress();
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("startup.progress")).thenReturn((Object)this.startupProgress);
        this.servlet = (StartupProgressServlet)((Object)Mockito.mock(StartupProgressServlet.class));
        Mockito.when((Object)this.servlet.getServletContext()).thenReturn((Object)context);
        ((StartupProgressServlet)((Object)Mockito.doCallRealMethod().when((Object)this.servlet))).doGet((HttpServletRequest)Mockito.any(HttpServletRequest.class), (HttpServletResponse)Mockito.any(HttpServletResponse.class));
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.respOut = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(this.respOut);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)this.resp.getWriter()).thenReturn((Object)writer);
    }

    @Test
    public void testInitialState() throws Exception {
        String respBody = this.doGetAndReturnResponseBody();
        Assert.assertNotNull((Object)respBody);
        ImmutableMap<String, List<Object>> expected = ImmutableMap.builder().put("percentComplete", Float.valueOf(0.0f)).put("phases", (Float)((Object)Arrays.asList(ImmutableMap.builder().put("name", "LoadingFsImage").put("desc", "Loading fsimage").put("status", "PENDING").put("percentComplete", (String)((Object)Float.valueOf(0.0f))).put("steps", (String)((Object)Collections.emptyList())).build(), ImmutableMap.builder().put("name", "LoadingEdits").put("desc", "Loading edits").put("status", "PENDING").put("percentComplete", (String)((Object)Float.valueOf(0.0f))).put("steps", (String)((Object)Collections.emptyList())).build(), ImmutableMap.builder().put("name", "SavingCheckpoint").put("desc", "Saving checkpoint").put("status", "PENDING").put("percentComplete", (String)((Object)Float.valueOf(0.0f))).put("steps", (String)((Object)Collections.emptyList())).build(), ImmutableMap.builder().put("name", "SafeMode").put("desc", "Safe mode").put("status", "PENDING").put("percentComplete", (String)((Object)Float.valueOf(0.0f))).put("steps", (String)((Object)Collections.emptyList())).build()))).build();
        Assert.assertEquals((Object)JSON.toString(expected), (Object)this.filterJson(respBody));
    }

    @Test
    public void testRunningState() throws Exception {
        StartupProgressTestHelper.setStartupProgressForRunningState(this.startupProgress);
        String respBody = this.doGetAndReturnResponseBody();
        Assert.assertNotNull((Object)respBody);
        ImmutableMap<String, List<Object>> expected = ImmutableMap.builder().put("percentComplete", Float.valueOf(0.375f)).put("phases", (Float)((Object)Arrays.asList(ImmutableMap.builder().put("name", "LoadingFsImage").put("desc", "Loading fsimage").put("status", "COMPLETE").put("percentComplete", (String)((Object)Float.valueOf(1.0f))).put("steps", (String)((Object)Collections.singletonList(ImmutableMap.builder().put("name", "Inodes").put("desc", "inodes").put("count", (String)((Object)Long.valueOf(100L))).put("total", (String)((Object)Long.valueOf(100L))).put("percentComplete", (String)((Object)Float.valueOf(1.0f))).build()))).build(), ImmutableMap.builder().put("name", "LoadingEdits").put("desc", "Loading edits").put("status", "RUNNING").put("percentComplete", (String)((Object)Float.valueOf(0.5f))).put("steps", (String)((Object)Collections.singletonList(ImmutableMap.builder().put("count", 100L).put("file", (Long)((Object)"file")).put("size", 1000L).put("total", 200L).put("percentComplete", (Long)((Object)Float.valueOf(0.5f))).build()))).build(), ImmutableMap.builder().put("name", "SavingCheckpoint").put("desc", "Saving checkpoint").put("status", "PENDING").put("percentComplete", (String)((Object)Float.valueOf(0.0f))).put("steps", (String)((Object)Collections.emptyList())).build(), ImmutableMap.builder().put("name", "SafeMode").put("desc", "Safe mode").put("status", "PENDING").put("percentComplete", (String)((Object)Float.valueOf(0.0f))).put("steps", (String)((Object)Collections.emptyList())).build()))).build();
        Assert.assertEquals((Object)JSON.toString(expected), (Object)this.filterJson(respBody));
    }

    @Test
    public void testFinalState() throws Exception {
        StartupProgressTestHelper.setStartupProgressForFinalState(this.startupProgress);
        String respBody = this.doGetAndReturnResponseBody();
        Assert.assertNotNull((Object)respBody);
        ImmutableMap<String, List<Object>> expected = ImmutableMap.builder().put("percentComplete", Float.valueOf(1.0f)).put("phases", (Float)((Object)Arrays.asList(ImmutableMap.builder().put("name", "LoadingFsImage").put("desc", "Loading fsimage").put("status", "COMPLETE").put("percentComplete", (String)((Object)Float.valueOf(1.0f))).put("steps", (String)((Object)Collections.singletonList(ImmutableMap.builder().put("name", "Inodes").put("desc", "inodes").put("count", (String)((Object)Long.valueOf(100L))).put("total", (String)((Object)Long.valueOf(100L))).put("percentComplete", (String)((Object)Float.valueOf(1.0f))).build()))).build(), ImmutableMap.builder().put("name", "LoadingEdits").put("desc", "Loading edits").put("status", "COMPLETE").put("percentComplete", (String)((Object)Float.valueOf(1.0f))).put("steps", (String)((Object)Collections.singletonList(ImmutableMap.builder().put("count", 200L).put("file", (Long)((Object)"file")).put("size", 1000L).put("total", 200L).put("percentComplete", (Long)((Object)Float.valueOf(1.0f))).build()))).build(), ImmutableMap.builder().put("name", "SavingCheckpoint").put("desc", "Saving checkpoint").put("status", "COMPLETE").put("percentComplete", (String)((Object)Float.valueOf(1.0f))).put("steps", (String)((Object)Collections.singletonList(ImmutableMap.builder().put("name", "Inodes").put("desc", "inodes").put("count", (String)((Object)Long.valueOf(300L))).put("total", (String)((Object)Long.valueOf(300L))).put("percentComplete", (String)((Object)Float.valueOf(1.0f))).build()))).build(), ImmutableMap.builder().put("name", "SafeMode").put("desc", "Safe mode").put("status", "COMPLETE").put("percentComplete", (String)((Object)Float.valueOf(1.0f))).put("steps", (String)((Object)Collections.singletonList(ImmutableMap.builder().put("name", "AwaitingReportedBlocks").put("desc", "awaiting reported blocks").put("count", (String)((Object)Long.valueOf(400L))).put("total", (String)((Object)Long.valueOf(400L))).put("percentComplete", (String)((Object)Float.valueOf(1.0f))).build()))).build()))).build();
        Assert.assertEquals((Object)JSON.toString(expected), (Object)this.filterJson(respBody));
    }

    private String doGetAndReturnResponseBody() throws IOException {
        this.servlet.doGet(this.req, this.resp);
        return new String(this.respOut.toByteArray(), "UTF-8");
    }

    private String filterJson(String str) {
        return str.replaceAll("\"elapsedTime\":\\d+\\,", "").replaceAll("\\,\"elapsedTime\":\\d+", "");
    }
}

