/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;

public class FileDiff
extends AbstractINodeDiff<INodeFile, INodeFileAttributes, FileDiff> {
    private final long fileSize;

    FileDiff(int snapshotId, INodeFile file) {
        super(snapshotId, null, null);
        this.fileSize = file.computeFileSize();
    }

    FileDiff(int snapshotId, INodeFileAttributes snapshotINode, FileDiff posteriorDiff, long fileSize) {
        super(snapshotId, snapshotINode, posteriorDiff);
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    Quota.Counts combinePosteriorAndCollectBlocks(INodeFile currentINode, FileDiff posterior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        return currentINode.getFileWithSnapshotFeature().updateQuotaAndCollectBlocks(currentINode, posterior, collectedBlocks, removedINodes);
    }

    @Override
    public String toString() {
        return super.toString() + " fileSize=" + this.fileSize + ", rep=" + (this.snapshotINode == null ? "?" : Short.valueOf(((INodeFileAttributes)this.snapshotINode).getFileReplication()));
    }

    @Override
    Quota.Counts destroyDiffAndCollectBlocks(INodeFile currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        return currentINode.getFileWithSnapshotFeature().updateQuotaAndCollectBlocks(currentINode, this, collectedBlocks, removedINodes);
    }
}

