/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;

@InterfaceAudience.Private
public class FileWithSnapshotFeature
implements INode.Feature {
    private final FileDiffList diffs;
    private boolean isCurrentFileDeleted = false;

    public FileWithSnapshotFeature(FileDiffList diffs) {
        this.diffs = diffs != null ? diffs : new FileDiffList();
    }

    public boolean isCurrentFileDeleted() {
        return this.isCurrentFileDeleted;
    }

    public void deleteCurrentFile() {
        this.isCurrentFileDeleted = true;
    }

    public FileDiffList getDiffs() {
        return this.diffs;
    }

    public short getMaxBlockRepInDiffs() {
        short max = 0;
        for (FileDiff d : this.getDiffs()) {
            short replication;
            if (d.snapshotINode == null || (replication = ((INodeFileAttributes)d.snapshotINode).getFileReplication()) <= max) continue;
            max = replication;
        }
        return max;
    }

    public String getDetailedString() {
        return (this.isCurrentFileDeleted() ? "(DELETED), " : ", ") + this.diffs;
    }

    public Quota.Counts cleanFile(INodeFile file, int snapshotId, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
        if (snapshotId == 0x7FFFFFFE) {
            if (!this.isCurrentFileDeleted()) {
                file.recordModification(priorSnapshotId);
                this.deleteCurrentFile();
            }
            this.collectBlocksAndClear(file, collectedBlocks, removedINodes);
            return Quota.Counts.newInstance();
        }
        priorSnapshotId = this.getDiffs().updatePrior(snapshotId, priorSnapshotId);
        return this.diffs.deleteSnapshotDiff(snapshotId, priorSnapshotId, file, collectedBlocks, removedINodes, countDiffChange);
    }

    public void clearDiffs() {
        this.diffs.clear();
    }

    public Quota.Counts updateQuotaAndCollectBlocks(INodeFile file, FileDiff removed, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        long oldDiskspace = file.diskspaceConsumed();
        if (removed.snapshotINode != null) {
            short replication = ((INodeFileAttributes)removed.snapshotINode).getFileReplication();
            short currentRepl = file.getBlockReplication();
            if (currentRepl == 0) {
                oldDiskspace = file.computeFileSize(true, true) * (long)replication;
            } else if (replication > currentRepl) {
                oldDiskspace = oldDiskspace / (long)file.getBlockReplication() * (long)replication;
            }
        }
        this.collectBlocksAndClear(file, collectedBlocks, removedINodes);
        long dsDelta = oldDiskspace - file.diskspaceConsumed();
        return Quota.Counts.newInstance(0L, dsDelta);
    }

    private void collectBlocksAndClear(INodeFile file, INode.BlocksMapUpdateInfo info, List<INode> removedINodes) {
        FileDiff last;
        if (this.isCurrentFileDeleted() && this.getDiffs().asList().isEmpty()) {
            file.destroyAndCollectBlocks(info, removedINodes);
            return;
        }
        long max = this.isCurrentFileDeleted() ? ((last = (FileDiff)this.getDiffs().getLast()) == null ? 0L : last.getFileSize()) : file.computeFileSize();
        this.collectBlocksBeyondMax(file, max, info);
    }

    private void collectBlocksBeyondMax(INodeFile file, long max, INode.BlocksMapUpdateInfo collectedBlocks) {
        BlockInfo[] oldBlocks = file.getBlocks();
        if (oldBlocks != null) {
            int n = 0;
            for (long size = 0L; n < oldBlocks.length && max > size; size += oldBlocks[n].getNumBytes(), ++n) {
            }
            if (n < oldBlocks.length) {
                BlockInfo[] newBlocks;
                if (n == 0) {
                    newBlocks = null;
                } else {
                    newBlocks = new BlockInfo[n];
                    System.arraycopy(oldBlocks, 0, newBlocks, 0, n);
                }
                file.setBlocks(newBlocks);
                if (collectedBlocks != null) {
                    while (n < oldBlocks.length) {
                        collectedBlocks.addDeleteBlock(oldBlocks[n]);
                        ++n;
                    }
                }
            }
        }
    }
}

