/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSnapshotFileLength {
    private static final long SEED = 0L;
    private static final short REPLICATION = 1;
    private static final int BLOCKSIZE = 1024;
    private static final Configuration conf = new Configuration();
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem hdfs;
    private final Path dir = new Path("/TestSnapshotFileLength");
    private final Path sub = new Path(this.dir, "sub1");
    private final String file1Name = "file1";
    private final String snapshot1 = "snapshot1";

    @Before
    public void setUp() throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test(timeout=300000L)
    public void testSnapshotfileLength() throws Exception {
        hdfs.mkdirs(this.sub);
        byte[] buffer = new byte[8192];
        FSDataInputStream fis = null;
        FileStatus fileStatus = null;
        Path file1 = new Path(this.sub, "file1");
        DFSTestUtil.createFile(hdfs, file1, 0L, (short)1, 0L);
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, 1024);
        hdfs.allowSnapshot(this.sub);
        hdfs.createSnapshot(this.sub, "snapshot1");
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, 1024);
        fileStatus = hdfs.getFileStatus(file1);
        Assert.assertThat((Object)fileStatus.getLen(), (Matcher)CoreMatchers.is((Object)2048L));
        fis = hdfs.open(file1);
        int bytesRead = fis.read(0L, buffer, 0, buffer.length);
        Assert.assertThat((Object)bytesRead, (Matcher)CoreMatchers.is((Object)2048));
        fis.close();
        Path file1snap1 = SnapshotTestHelper.getSnapshotPath(this.sub, "snapshot1", "file1");
        fis = hdfs.open(file1snap1);
        fileStatus = hdfs.getFileStatus(file1snap1);
        Assert.assertThat((Object)fileStatus.getLen(), (Matcher)CoreMatchers.is((Object)1024L));
        bytesRead = fis.read(0L, buffer, 0, buffer.length);
        Assert.assertThat((Object)bytesRead, (Matcher)CoreMatchers.is((Object)1024));
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testSnapshotFileLengthWithCatCommand() throws Exception {
        FSDataInputStream fis = null;
        FileStatus fileStatus = null;
        byte[] buffer = new byte[8192];
        hdfs.mkdirs(this.sub);
        Path file1 = new Path(this.sub, "file1");
        DFSTestUtil.createFile(hdfs, file1, 1024L, (short)1, 0L);
        hdfs.allowSnapshot(this.sub);
        hdfs.createSnapshot(this.sub, "snapshot1");
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, 1024);
        fileStatus = hdfs.getFileStatus(file1);
        Assert.assertEquals((long)fileStatus.getLen(), (long)2048L);
        fis = hdfs.open(file1);
        int bytesRead = fis.read(buffer, 0, buffer.length);
        Assert.assertEquals((long)bytesRead, (long)2048L);
        fis.close();
        Path file1snap1 = SnapshotTestHelper.getSnapshotPath(this.sub, "snapshot1", "file1");
        fis = hdfs.open(file1snap1);
        fileStatus = hdfs.getFileStatus(file1snap1);
        Assert.assertEquals((long)fileStatus.getLen(), (long)1024L);
        bytesRead = fis.read(buffer, 0, buffer.length);
        Assert.assertEquals((long)bytesRead, (long)1024L);
        fis.close();
        PrintStream psBackup = System.out;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        FsShell shell = new FsShell();
        try {
            ToolRunner.run(conf, shell, new String[]{"-cat", "/TestSnapshotFileLength/sub1/.snapshot/snapshot1/file1"});
            Assert.assertEquals((long)bao.size(), (long)1024L);
        }
        finally {
            System.setOut(psBackup);
        }
    }
}

