/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressMetrics;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressTestHelper;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStartupProgressMetrics {
    private StartupProgress startupProgress;
    private StartupProgressMetrics metrics;

    @Before
    public void setUp() {
        MetricsAsserts.mockMetricsSystem();
        this.startupProgress = new StartupProgress();
        this.metrics = new StartupProgressMetrics(this.startupProgress);
    }

    @Test
    public void testInitialState() {
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics(this.metrics, true);
        MetricsAsserts.assertCounter("ElapsedTime", 0L, builder);
        MetricsAsserts.assertGauge("PercentComplete", 0.0f, builder);
        MetricsAsserts.assertCounter("LoadingFsImageCount", 0L, builder);
        MetricsAsserts.assertCounter("LoadingFsImageElapsedTime", 0L, builder);
        MetricsAsserts.assertCounter("LoadingFsImageTotal", 0L, builder);
        MetricsAsserts.assertGauge("LoadingFsImagePercentComplete", 0.0f, builder);
        MetricsAsserts.assertCounter("LoadingEditsCount", 0L, builder);
        MetricsAsserts.assertCounter("LoadingEditsElapsedTime", 0L, builder);
        MetricsAsserts.assertCounter("LoadingEditsTotal", 0L, builder);
        MetricsAsserts.assertGauge("LoadingEditsPercentComplete", 0.0f, builder);
        MetricsAsserts.assertCounter("SavingCheckpointCount", 0L, builder);
        MetricsAsserts.assertCounter("SavingCheckpointElapsedTime", 0L, builder);
        MetricsAsserts.assertCounter("SavingCheckpointTotal", 0L, builder);
        MetricsAsserts.assertGauge("SavingCheckpointPercentComplete", 0.0f, builder);
        MetricsAsserts.assertCounter("SafeModeCount", 0L, builder);
        MetricsAsserts.assertCounter("SafeModeElapsedTime", 0L, builder);
        MetricsAsserts.assertCounter("SafeModeTotal", 0L, builder);
        MetricsAsserts.assertGauge("SafeModePercentComplete", 0.0f, builder);
    }

    @Test
    public void testRunningState() {
        StartupProgressTestHelper.setStartupProgressForRunningState(this.startupProgress);
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics(this.metrics, true);
        Assert.assertTrue((MetricsAsserts.getLongCounter("ElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertGauge("PercentComplete", 0.375f, builder);
        MetricsAsserts.assertCounter("LoadingFsImageCount", 100L, builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter("LoadingFsImageElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter("LoadingFsImageTotal", 100L, builder);
        MetricsAsserts.assertGauge("LoadingFsImagePercentComplete", 1.0f, builder);
        MetricsAsserts.assertCounter("LoadingEditsCount", 100L, builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter("LoadingEditsElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter("LoadingEditsTotal", 200L, builder);
        MetricsAsserts.assertGauge("LoadingEditsPercentComplete", 0.5f, builder);
        MetricsAsserts.assertCounter("SavingCheckpointCount", 0L, builder);
        MetricsAsserts.assertCounter("SavingCheckpointElapsedTime", 0L, builder);
        MetricsAsserts.assertCounter("SavingCheckpointTotal", 0L, builder);
        MetricsAsserts.assertGauge("SavingCheckpointPercentComplete", 0.0f, builder);
        MetricsAsserts.assertCounter("SafeModeCount", 0L, builder);
        MetricsAsserts.assertCounter("SafeModeElapsedTime", 0L, builder);
        MetricsAsserts.assertCounter("SafeModeTotal", 0L, builder);
        MetricsAsserts.assertGauge("SafeModePercentComplete", 0.0f, builder);
    }

    @Test
    public void testFinalState() {
        StartupProgressTestHelper.setStartupProgressForFinalState(this.startupProgress);
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics(this.metrics, true);
        Assert.assertTrue((MetricsAsserts.getLongCounter("ElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertGauge("PercentComplete", 1.0f, builder);
        MetricsAsserts.assertCounter("LoadingFsImageCount", 100L, builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter("LoadingFsImageElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter("LoadingFsImageTotal", 100L, builder);
        MetricsAsserts.assertGauge("LoadingFsImagePercentComplete", 1.0f, builder);
        MetricsAsserts.assertCounter("LoadingEditsCount", 200L, builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter("LoadingEditsElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter("LoadingEditsTotal", 200L, builder);
        MetricsAsserts.assertGauge("LoadingEditsPercentComplete", 1.0f, builder);
        MetricsAsserts.assertCounter("SavingCheckpointCount", 300L, builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter("SavingCheckpointElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter("SavingCheckpointTotal", 300L, builder);
        MetricsAsserts.assertGauge("SavingCheckpointPercentComplete", 1.0f, builder);
        MetricsAsserts.assertCounter("SafeModeCount", 400L, builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter("SafeModeElapsedTime", builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter("SafeModeTotal", 400L, builder);
        MetricsAsserts.assertGauge("SafeModePercentComplete", 1.0f, builder);
    }
}

