/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.util.Diff;
import org.junit.Assert;
import org.junit.Test;

public class TestDiff {
    private static final Random RANDOM = new Random();
    private static final int UNDO_TEST_P = 10;
    private static final PermissionStatus PERM = PermissionStatus.createImmutable("user", "group", FsPermission.createImmutable((short)0));

    static int nextStep(int n) {
        return n == 0 ? 1 : 10 * n;
    }

    @Test(timeout=60000L)
    public void testDiff() throws Exception {
        int startSize = 0;
        while (startSize <= 10000) {
            int m = 0;
            while (m <= 10000) {
                this.runDiffTest(startSize, m);
                m = TestDiff.nextStep(m);
            }
            startSize = TestDiff.nextStep(startSize);
        }
    }

    void runDiffTest(int startSize, int numModifications) {
        int n;
        int width = TestDiff.findWidth(startSize + numModifications);
        System.out.println("\nstartSize=" + startSize + ", numModifications=" + numModifications + ", width=" + width);
        ArrayList<INode> previous = new ArrayList<INode>();
        for (n = 0; n < startSize; ++n) {
            previous.add(TestDiff.newINode(n, width));
        }
        ArrayList<INode> current = new ArrayList<INode>(previous);
        ArrayList diffs = new ArrayList();
        for (int j = 0; j < 5; ++j) {
            diffs.add(new Diff());
        }
        block7: for (int m = 0; m < numModifications; ++m) {
            int j = m * diffs.size() / numModifications;
            int nextOperation = current.isEmpty() ? 1 : RANDOM.nextInt(3) + 1;
            switch (nextOperation) {
                case 1: {
                    INode i = TestDiff.newINode(n++, width);
                    TestDiff.create(i, current, (Diff)diffs.get(j));
                    continue block7;
                }
                case 2: {
                    INode i = (INode)current.get(RANDOM.nextInt(current.size()));
                    TestDiff.delete(i, current, (Diff)diffs.get(j));
                    continue block7;
                }
                case 3: {
                    INode i = (INode)current.get(RANDOM.nextInt(current.size()));
                    TestDiff.modify(i, current, (Diff)diffs.get(j));
                    continue block7;
                }
            }
        }
        List<INode> c = previous;
        for (int i = 0; i < diffs.size(); ++i) {
            c = ((Diff)diffs.get(i)).apply2Previous(c);
        }
        if (!TestDiff.hasIdenticalElements(current, c)) {
            System.out.println("previous = " + previous);
            System.out.println();
            System.out.println("current  = " + current);
            System.out.println("c        = " + c);
            throw new AssertionError((Object)"current and c are not identical.");
        }
        List<INode> p = current;
        for (int i = diffs.size() - 1; i >= 0; --i) {
            p = ((Diff)diffs.get(i)).apply2Current(p);
        }
        if (!TestDiff.hasIdenticalElements(previous, p)) {
            System.out.println("previous = " + previous);
            System.out.println("p        = " + p);
            System.out.println();
            System.out.println("current  = " + current);
            throw new AssertionError((Object)"previous and p are not identical.");
        }
        Diff combined = (Diff)diffs.get(0);
        for (int i = 1; i < diffs.size(); ++i) {
            combined.combinePosterior((Diff)diffs.get(i), null);
        }
        List<INode> c2 = combined.apply2Previous(previous);
        if (!TestDiff.hasIdenticalElements(current, c2)) {
            System.out.println("previous = " + previous);
            System.out.println();
            System.out.println("current  = " + current);
            System.out.println("c        = " + c2);
            throw new AssertionError((Object)"current and c are not identical.");
        }
        List<INode> p2 = combined.apply2Current(current);
        if (!TestDiff.hasIdenticalElements(previous, p2)) {
            System.out.println("previous = " + previous);
            System.out.println("p        = " + p2);
            System.out.println();
            System.out.println("current  = " + current);
            throw new AssertionError((Object)"previous and p are not identical.");
        }
        for (int m = 0; m < n; ++m) {
            int i;
            INode inode = TestDiff.newINode(m, width);
            Diff.Container r = combined.accessPrevious(inode.getKey());
            INode computed = r != null ? (INode)r.getElement() : ((i = Diff.search(current, inode.getKey())) < 0 ? null : (INode)current.get(i));
            int j = Diff.search(previous, inode.getKey());
            INode expected = j < 0 ? null : (INode)previous.get(j);
            Assert.assertTrue((computed == expected ? 1 : 0) != 0);
            r = combined.accessCurrent(inode.getKey());
            computed = r != null ? (INode)r.getElement() : ((i = Diff.search(previous, inode.getKey())) < 0 ? null : (INode)previous.get(i));
            j = Diff.search(current, inode.getKey());
            expected = j < 0 ? null : (INode)current.get(j);
            Assert.assertTrue((computed == expected ? 1 : 0) != 0);
        }
    }

    static boolean hasIdenticalElements(List<INode> expected, List<INode> computed) {
        if (expected == null) {
            return computed == null;
        }
        if (expected.size() != computed.size()) {
            return false;
        }
        for (int i = 0; i < expected.size(); ++i) {
            if (expected.get(i) == computed.get(i)) continue;
            return false;
        }
        return true;
    }

    static String toString(INode inode) {
        return inode == null ? null : inode.getLocalName() + ":" + inode.getModificationTime();
    }

    static int findWidth(int max) {
        int w = 1;
        long n = 10L;
        while (n < (long)max) {
            n *= 10L;
            ++w;
        }
        return w;
    }

    static INode newINode(int n, int width) {
        byte[] name = DFSUtil.string2Bytes(String.format("n%0" + width + "d", n));
        return new INodeDirectory(n, name, PERM, 0L);
    }

    static void create(INode inode, List<INode> current, Diff<byte[], INode> diff) {
        int i = Diff.search(current, inode.getKey());
        Assert.assertTrue((i < 0 ? 1 : 0) != 0);
        current.add(-i - 1, inode);
        if (diff != null) {
            boolean testUndo = RANDOM.nextInt(10) == 0;
            String before = null;
            if (testUndo) {
                before = diff.toString();
            }
            int undoInfo = diff.create(inode);
            if (testUndo) {
                String after = diff.toString();
                diff.undoCreate(inode, undoInfo);
                TestDiff.assertDiff(before, diff);
                diff.create(inode);
                TestDiff.assertDiff(after, diff);
            }
        }
    }

    static void delete(INode inode, List<INode> current, Diff<byte[], INode> diff) {
        int i = Diff.search(current, inode.getKey());
        current.remove(i);
        if (diff != null) {
            boolean testUndo = RANDOM.nextInt(10) == 0;
            String before = null;
            if (testUndo) {
                before = diff.toString();
            }
            Diff.UndoInfo<INode> undoInfo = diff.delete(inode);
            if (testUndo) {
                String after = diff.toString();
                diff.undoDelete(inode, undoInfo);
                TestDiff.assertDiff(before, diff);
                diff.delete(inode);
                TestDiff.assertDiff(after, diff);
            }
        }
    }

    static void modify(INode inode, List<INode> current, Diff<byte[], INode> diff) {
        int i = Diff.search(current, inode.getKey());
        Assert.assertTrue((i >= 0 ? 1 : 0) != 0);
        INodeDirectory oldinode = (INodeDirectory)current.get(i);
        INodeDirectory newinode = new INodeDirectory(oldinode, false, oldinode.getFeatures());
        newinode.setModificationTime(oldinode.getModificationTime() + 1L);
        current.set(i, newinode);
        if (diff != null) {
            boolean testUndo = RANDOM.nextInt(10) == 0;
            String before = null;
            if (testUndo) {
                before = diff.toString();
            }
            Diff.UndoInfo<INode> undoInfo = diff.modify(oldinode, newinode);
            if (testUndo) {
                String after = diff.toString();
                diff.undoModify(oldinode, newinode, undoInfo);
                TestDiff.assertDiff(before, diff);
                diff.modify(oldinode, newinode);
                TestDiff.assertDiff(after, diff);
            }
        }
    }

    static void assertDiff(String s, Diff<byte[], INode> diff) {
        Assert.assertEquals((Object)s, (Object)diff.toString());
    }
}

