/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWebHdfsTimeouts {
    private static final Log LOG = LogFactory.getLog(TestWebHdfsTimeouts.class);
    private static final int CLIENTS_TO_CONSUME_BACKLOG = 100;
    private static final int CONNECTION_BACKLOG = 1;
    private static final int SHORT_SOCKET_TIMEOUT = 5;
    private static final int TEST_TIMEOUT = 10000;
    private List<SocketChannel> clients;
    private WebHdfsFileSystem fs;
    private InetSocketAddress nnHttpAddress;
    private ServerSocket serverSocket;
    private Thread serverThread;
    private final URLConnectionFactory connectionFactory = new URLConnectionFactory(new ConnectionConfigurator(){

        @Override
        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            conn.setReadTimeout(5);
            conn.setConnectTimeout(5);
            return conn;
        }
    });

    @Before
    public void setUp() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        this.serverSocket = new ServerSocket(0, 1);
        this.nnHttpAddress = new InetSocketAddress("localhost", this.serverSocket.getLocalPort());
        conf.set("dfs.namenode.http-address", "localhost:" + this.serverSocket.getLocalPort());
        this.fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
        this.fs.connectionFactory = this.connectionFactory;
        this.clients = new ArrayList<SocketChannel>();
        this.serverThread = null;
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.cleanup(LOG, this.clients.toArray(new SocketChannel[this.clients.size()]));
        IOUtils.cleanup(LOG, this.fs);
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception in closing " + this.serverSocket), (Throwable)e);
            }
        }
        if (this.serverThread != null) {
            this.serverThread.join();
        }
    }

    @Test(timeout=10000L)
    public void testConnectTimeout() throws Exception {
        this.consumeConnectionBacklog();
        try {
            this.fs.listFiles(new Path("/"), false);
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            Assert.assertEquals((Object)"connect timed out", (Object)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testReadTimeout() throws Exception {
        try {
            this.fs.listFiles(new Path("/"), false);
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            Assert.assertEquals((Object)"Read timed out", (Object)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testAuthUrlConnectTimeout() throws Exception {
        this.consumeConnectionBacklog();
        try {
            this.fs.getDelegationToken("renewer");
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            Assert.assertEquals((Object)"connect timed out", (Object)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testAuthUrlReadTimeout() throws Exception {
        try {
            this.fs.getDelegationToken("renewer");
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            Assert.assertEquals((Object)"Read timed out", (Object)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testRedirectConnectTimeout() throws Exception {
        this.startSingleTemporaryRedirectResponseThread(true);
        try {
            this.fs.getFileChecksum(new Path("/file"));
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            Assert.assertEquals((Object)"connect timed out", (Object)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testRedirectReadTimeout() throws Exception {
        this.startSingleTemporaryRedirectResponseThread(false);
        try {
            this.fs.getFileChecksum(new Path("/file"));
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            Assert.assertEquals((Object)"Read timed out", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTwoStepWriteConnectTimeout() throws Exception {
        this.startSingleTemporaryRedirectResponseThread(true);
        FSDataOutputStream os = null;
        try {
            os = this.fs.create(new Path("/file"));
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            try {
                Assert.assertEquals((Object)"connect timed out", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, os);
                throw throwable;
            }
            IOUtils.cleanup(LOG, os);
        }
        IOUtils.cleanup(LOG, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTwoStepWriteReadTimeout() throws Exception {
        this.startSingleTemporaryRedirectResponseThread(false);
        FSDataOutputStream os = null;
        try {
            os = this.fs.create(new Path("/file"));
            ((OutputStream)os).close();
            os = null;
            Assert.fail((String)"expected timeout");
        }
        catch (SocketTimeoutException e) {
            try {
                Assert.assertEquals((Object)"Read timed out", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, os);
                throw throwable;
            }
            IOUtils.cleanup(LOG, os);
        }
        IOUtils.cleanup(LOG, os);
    }

    private void startSingleTemporaryRedirectResponseThread(final boolean consumeConnectionBacklog) {
        this.fs.connectionFactory = URLConnectionFactory.DEFAULT_SYSTEM_CONNECTION_FACTORY;
        this.serverThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Socket clientSocket = null;
                OutputStream out = null;
                InputStream in = null;
                InputStreamReader isr = null;
                BufferedReader br = null;
                try {
                    String line;
                    clientSocket = TestWebHdfsTimeouts.this.serverSocket.accept();
                    ((TestWebHdfsTimeouts)TestWebHdfsTimeouts.this).fs.connectionFactory = TestWebHdfsTimeouts.this.connectionFactory;
                    if (consumeConnectionBacklog) {
                        TestWebHdfsTimeouts.this.consumeConnectionBacklog();
                    }
                    in = clientSocket.getInputStream();
                    isr = new InputStreamReader(in);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null && !line.isEmpty()) {
                    }
                    out = clientSocket.getOutputStream();
                    out.write(TestWebHdfsTimeouts.this.temporaryRedirect().getBytes("UTF-8"));
                }
                catch (IOException e) {
                    try {
                        LOG.error((Object)"unexpected IOException in server thread", (Throwable)e);
                        Assert.fail((String)("unexpected IOException in server thread: " + e));
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanup(LOG, br, isr, in, out);
                        IOUtils.closeSocket(clientSocket);
                        throw throwable;
                    }
                    IOUtils.cleanup(LOG, br, isr, in, out);
                    IOUtils.closeSocket(clientSocket);
                }
                IOUtils.cleanup(LOG, br, isr, in, out);
                IOUtils.closeSocket(clientSocket);
            }
        };
        this.serverThread.start();
    }

    private void consumeConnectionBacklog() throws IOException {
        for (int i = 0; i < 100; ++i) {
            SocketChannel client = SocketChannel.open();
            client.configureBlocking(false);
            client.connect(this.nnHttpAddress);
            this.clients.add(client);
        }
    }

    private String temporaryRedirect() {
        return "HTTP/1.1 307 Temporary Redirect\r\nLocation: http://" + NetUtils.getHostPortString(this.nnHttpAddress) + "\r\n" + "\r\n";
    }
}

