/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BloomMapFile;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.TestMapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.mockito.Mockito;

public class TestBloomMapFile
extends TestCase {
    private static Configuration conf = new Configuration();
    private static final Path TEST_ROOT = new Path(System.getProperty("test.build.data", "/tmp"), TestMapFile.class.getSimpleName());
    private static final Path TEST_DIR = new Path(TEST_ROOT, "testfile");
    private static final Path TEST_FILE = new Path(TEST_ROOT, "testfile");
    static final Progressable defaultProgress = new Progressable(){

        @Override
        public void progress() {
        }
    };
    static final CompressionCodec defaultCodec = new CompressionCodec(){

        @Override
        public String getDefaultExtension() {
            return null;
        }

        @Override
        public Class<? extends Decompressor> getDecompressorType() {
            return null;
        }

        @Override
        public Class<? extends Compressor> getCompressorType() {
            return null;
        }

        @Override
        public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        @Override
        public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        @Override
        public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
            return null;
        }

        @Override
        public CompressionInputStream createInputStream(InputStream in) throws IOException {
            return null;
        }

        @Override
        public Decompressor createDecompressor() {
            return null;
        }

        @Override
        public Compressor createCompressor() {
            return null;
        }
    };

    public void setUp() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal(conf);
        if (fs.exists(TEST_ROOT) && !fs.delete(TEST_ROOT, true)) {
            Assert.fail((String)"Can't clean up test root dir");
        }
        fs.mkdirs(TEST_ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMembershipTest() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal(conf);
        Path qualifiedDirName = ((FileSystem)fs).makeQualified(TEST_DIR);
        conf.setInt("io.mapfile.bloom.size", 2048);
        BloomMapFile.Writer writer = null;
        BloomMapFile.Reader reader = null;
        try {
            writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, Text.class);
            IntWritable key = new IntWritable();
            Text value = new Text();
            for (int i = 0; i < 2000; i += 2) {
                key.set(i);
                value.set("00" + i);
                writer.append(key, value);
            }
            writer.close();
            reader = new BloomMapFile.Reader(fs, qualifiedDirName.toString(), conf);
            int falsePos = 0;
            int falseNeg = 0;
            for (int i = 0; i < 2000; ++i) {
                key.set(i);
                boolean exists = reader.probablyHasKey(key);
                if (i % 2 == 0) {
                    if (exists) continue;
                    ++falseNeg;
                    continue;
                }
                if (!exists) continue;
                ++falsePos;
            }
            reader.close();
            ((FileSystem)fs).delete(qualifiedDirName, true);
            System.out.println("False negatives: " + falseNeg);
            TestBloomMapFile.assertEquals((int)0, (int)falseNeg);
            System.out.println("False positives: " + falsePos);
            TestBloomMapFile.assertTrue((falsePos < 2 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, writer, reader);
            throw throwable;
        }
        IOUtils.cleanup(null, writer, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMembershipVaryingSizedKeys(String name, List<Text> keys) throws Exception {
        LocalFileSystem fs = FileSystem.getLocal(conf);
        Path qualifiedDirName = ((FileSystem)fs).makeQualified(TEST_DIR);
        BloomMapFile.Writer writer = null;
        BloomMapFile.Reader reader = null;
        try {
            writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), Text.class, NullWritable.class);
            for (Text key : keys) {
                writer.append(key, NullWritable.get());
            }
            writer.close();
            reader = new BloomMapFile.Reader(fs, qualifiedDirName.toString(), conf);
            Collections.reverse(keys);
            for (Text key : keys) {
                TestBloomMapFile.assertTrue((String)("False negative for existing key " + key), (boolean)reader.probablyHasKey(key));
            }
            reader.close();
            ((FileSystem)fs).delete(qualifiedDirName, true);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, writer, reader);
            throw throwable;
        }
        IOUtils.cleanup(null, writer, reader);
    }

    public void testMembershipVaryingSizedKeysTest1() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("A"));
        list.add(new Text("BB"));
        this.checkMembershipVaryingSizedKeys(this.getName(), list);
    }

    public void testMembershipVaryingSizedKeysTest2() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("AA"));
        list.add(new Text("B"));
        this.checkMembershipVaryingSizedKeys(this.getName(), list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFile() {
        BloomMapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal(conf);
            writer = new BloomMapFile.Writer(conf, TEST_FILE, MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class));
            TestBloomMapFile.assertNotNull((String)"testDeleteFile error !!!", (Object)writer);
            writer.close();
            BloomMapFile.delete(fs, TEST_FILE.toString());
        }
        catch (Exception ex) {
            try {
                TestBloomMapFile.fail((String)"unexpect ex in testDeleteFile !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, writer);
                throw throwable;
            }
            IOUtils.cleanup(null, writer);
        }
        IOUtils.cleanup(null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIOExceptionInWriterConstructor() {
        Path dirNameSpy = (Path)Mockito.spy((Object)TEST_FILE);
        BloomMapFile.Reader reader = null;
        BloomMapFile.Writer writer = null;
        try {
            writer = new BloomMapFile.Writer(conf, TEST_FILE, MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class));
            writer.append(new IntWritable(1), new Text("123124142"));
            writer.close();
            Mockito.when((Object)dirNameSpy.getFileSystem(conf)).thenThrow(new Throwable[]{new IOException()});
            reader = new BloomMapFile.Reader(dirNameSpy, conf, MapFile.Reader.comparator(new WritableComparator(IntWritable.class)));
            TestBloomMapFile.assertNull((String)"testIOExceptionInWriterConstructor error !!!", (Object)reader.getBloomFilter());
        }
        catch (Exception ex) {
            try {
                TestBloomMapFile.fail((String)"unexpect ex in testIOExceptionInWriterConstructor !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, writer, reader);
                throw throwable;
            }
            IOUtils.cleanup(null, writer, reader);
        }
        IOUtils.cleanup(null, writer, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBloomMapFile() {
        int SIZE = 10;
        BloomMapFile.Reader reader = null;
        BloomMapFile.Writer writer = null;
        try {
            int i;
            writer = new BloomMapFile.Writer(conf, TEST_FILE, MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class));
            for (i = 0; i < SIZE; ++i) {
                writer.append(new IntWritable(i), new Text());
            }
            writer.close();
            reader = new BloomMapFile.Reader(TEST_FILE, conf, MapFile.Reader.comparator(new WritableComparator(IntWritable.class)));
            for (i = 0; i < SIZE; ++i) {
                TestBloomMapFile.assertNotNull((String)"testGetBloomMapFile error !!!", (Object)reader.get(new IntWritable(i), new Text()));
            }
            TestBloomMapFile.assertNull((String)"testGetBloomMapFile error !!!", (Object)reader.get(new IntWritable(SIZE + 5), new Text()));
        }
        catch (Exception ex) {
            try {
                TestBloomMapFile.fail((String)"unexpect ex in testGetBloomMapFile !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, writer, reader);
                throw throwable;
            }
            IOUtils.cleanup(null, writer, reader);
        }
        IOUtils.cleanup(null, writer, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBloomMapFileConstructors() {
        BloomMapFile.Writer writer = null;
        try {
            FileSystem ts = FileSystem.get(conf);
            String testFileName = TEST_FILE.toString();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK, defaultCodec, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultCodec, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, WritableComparator.get(Text.class), Text.class);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
        }
        catch (Exception ex) {
            try {
                TestBloomMapFile.fail((String)"testBloomMapFileConstructors error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, writer);
                throw throwable;
            }
            IOUtils.cleanup(null, writer);
        }
        IOUtils.cleanup(null, writer);
    }
}

