/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;

public class TestDefaultStringifier
extends TestCase {
    private static Configuration conf = new Configuration();
    private static final Log LOG = LogFactory.getLog(TestDefaultStringifier.class);
    private char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toCharArray();

    public void testWithWritable() throws Exception {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization");
        LOG.info((Object)"Testing DefaultStringifier with Text");
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            StringBuilder builder = new StringBuilder();
            int strLen = random.nextInt(40);
            for (int j = 0; j < strLen; ++j) {
                builder.append(this.alphabet[random.nextInt(this.alphabet.length)]);
            }
            Text text = new Text(builder.toString());
            DefaultStringifier<Text> stringifier = new DefaultStringifier<Text>(conf, Text.class);
            String str = stringifier.toString(text);
            Text claimedText = stringifier.fromString(str);
            LOG.info((Object)("Object: " + text));
            LOG.info((Object)("String representation of the object: " + str));
            TestDefaultStringifier.assertEquals((Object)text, (Object)claimedText);
        }
    }

    public void testWithJavaSerialization() throws Exception {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        LOG.info((Object)"Testing DefaultStringifier with Serializable Integer");
        Integer testInt = 42;
        DefaultStringifier<Integer> stringifier = new DefaultStringifier<Integer>(conf, Integer.class);
        String str = stringifier.toString(testInt);
        Integer claimedInt = stringifier.fromString(str);
        LOG.info((Object)("String representation of the object: " + str));
        TestDefaultStringifier.assertEquals((Object)testInt, (Object)claimedInt);
    }

    public void testStoreLoad() throws IOException {
        LOG.info((Object)"Testing DefaultStringifier#store() and #load()");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization");
        Text text = new Text("uninteresting test string");
        String keyName = "test.defaultstringifier.key1";
        DefaultStringifier.store(conf, text, keyName);
        Text claimedText = DefaultStringifier.load(conf, keyName, Text.class);
        TestDefaultStringifier.assertEquals((String)"DefaultStringifier#load() or #store() might be flawed", (Object)text, (Object)claimedText);
    }

    public void testStoreLoadArray() throws IOException {
        LOG.info((Object)"Testing DefaultStringifier#storeArray() and #loadArray()");
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        String keyName = "test.defaultstringifier.key2";
        Integer[] array = new Integer[]{1, 2, 3, 4, 5};
        DefaultStringifier.storeArray(conf, array, keyName);
        Integer[] claimedArray = DefaultStringifier.loadArray(conf, keyName, Integer.class);
        for (int i = 0; i < array.length; ++i) {
            TestDefaultStringifier.assertEquals((String)"two arrays are not equal", (Object)array[i], (Object)claimedArray[i]);
        }
    }
}

