/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import org.apache.hadoop.io.compress.Decompressor;

class FakeDecompressor
implements Decompressor {
    private boolean finish;
    private boolean finished;
    int nread;
    int nwrite;
    byte[] userBuf;
    int userBufOff;
    int userBufLen;

    FakeDecompressor() {
    }

    @Override
    public int decompress(byte[] b, int off, int len) throws IOException {
        int n = Math.min(len, this.userBufLen);
        if (this.userBuf != null && b != null) {
            System.arraycopy(this.userBuf, this.userBufOff, b, off, n);
        }
        this.userBufOff += n;
        this.userBufLen -= n;
        this.nwrite += n;
        if (this.finish && this.userBufLen <= 0) {
            this.finished = true;
        }
        return n;
    }

    @Override
    public void end() {
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public boolean needsDictionary() {
        return false;
    }

    @Override
    public boolean needsInput() {
        return this.userBufLen <= 0;
    }

    @Override
    public void reset() {
        this.finish = false;
        this.finished = false;
        this.nread = 0;
        this.nwrite = 0;
        this.userBuf = null;
        this.userBufOff = 0;
        this.userBufLen = 0;
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        this.nread += len;
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
    }

    @Override
    public int getRemaining() {
        return 0;
    }
}

