/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.FakeCompressor;
import org.apache.hadoop.io.compress.FakeDecompressor;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockDecompressorStream {
    private byte[] buf;
    private ByteArrayInputStream bytesIn;
    private ByteArrayOutputStream bytesOut;

    @Test
    public void testRead1() throws IOException {
        this.testRead(0);
    }

    @Test
    public void testRead2() throws IOException {
        this.testRead(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRead(int bufLen) throws IOException {
        this.bytesOut = new ByteArrayOutputStream();
        if (bufLen > 0) {
            this.bytesOut.write(ByteBuffer.allocate(bufLen).putInt(1024).array(), 0, bufLen);
        }
        BlockCompressorStream blockCompressorStream = new BlockCompressorStream(this.bytesOut, new FakeCompressor(), 1024, 0);
        blockCompressorStream.close();
        this.buf = this.bytesOut.toByteArray();
        Assert.assertEquals((String)("empty file compressed output size is not " + (bufLen + 4)), (long)(bufLen + 4), (long)this.buf.length);
        this.bytesIn = new ByteArrayInputStream(this.buf);
        BlockDecompressorStream blockDecompressorStream = new BlockDecompressorStream(this.bytesIn, new FakeDecompressor(), 1024);
        try {
            Assert.assertEquals((String)"return value is not -1", (long)-1L, (long)blockDecompressorStream.read());
        }
        catch (IOException e) {
            Assert.fail((String)("unexpected IOException : " + e));
        }
        finally {
            blockDecompressorStream.close();
        }
    }
}

