/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.UnreliableImplementation;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.util.ThreadUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestFailoverProxy {
    private static FlipFlopProxyProvider<UnreliableInterface> newFlipFlopProxyProvider() {
        return new FlipFlopProxyProvider<UnreliableInterface>(UnreliableInterface.class, new UnreliableImplementation("impl1"), new UnreliableImplementation("impl2"));
    }

    private static FlipFlopProxyProvider<UnreliableInterface> newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith t1, UnreliableImplementation.TypeOfExceptionToFailWith t2) {
        return new FlipFlopProxyProvider<UnreliableInterface>(UnreliableInterface.class, new UnreliableImplementation("impl1", t1), new UnreliableImplementation("impl2", t2));
    }

    @Test
    public void testSuccedsOnceThenFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), (RetryPolicy)new FailOverOnceOnAnyExceptionPolicy());
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assert.fail((String)"should not have succeeded more than twice");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testSucceedsTenTimesThenFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), (RetryPolicy)new FailOverOnceOnAnyExceptionPolicy());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsTenTimesThenFailsReturningString());
        }
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsTenTimesThenFailsReturningString());
    }

    @Test
    public void testNeverFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), RetryPolicies.TRY_ONCE_THEN_FAIL);
        unreliable.succeedsOnceThenFailsReturningString();
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assert.fail((String)"should not have succeeded twice");
        }
        catch (UnreliableInterface.UnreliableException e) {
            Assert.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
    }

    @Test
    public void testFailoverOnStandbyException() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), RetryPolicies.failoverOnNetworkException(1));
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assert.fail((String)"should not have succeeded twice");
        }
        catch (UnreliableInterface.UnreliableException e) {
            Assert.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
        unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), RetryPolicies.failoverOnNetworkException(1));
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningString());
    }

    @Test
    public void testFailoverOnNetworkExceptionIdempotentOperation() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.IO_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), RetryPolicies.failoverOnNetworkException(1));
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assert.fail((String)"should not have succeeded twice");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningStringIdempotent());
        Assert.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningStringIdempotent());
    }

    @Test
    public void testExceptionPropagatedForNonIdempotentVoid() throws Exception {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.IO_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), RetryPolicies.failoverOnNetworkException(1));
        try {
            unreliable.nonIdempotentVoidFailsIfIdentifierDoesntMatch("impl2");
            Assert.fail((String)"did not throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentMethodFailures() throws InterruptedException {
        FlipFlopProxyProvider<UnreliableImplementation> proxyProvider = new FlipFlopProxyProvider<UnreliableImplementation>(UnreliableInterface.class, new SynchronizedUnreliableImplementation("impl1", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION, 2), new UnreliableImplementation("impl2", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION));
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, proxyProvider, RetryPolicies.failoverOnNetworkException(10));
        ConcurrentMethodThread t1 = new ConcurrentMethodThread(unreliable);
        ConcurrentMethodThread t2 = new ConcurrentMethodThread(unreliable);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertEquals((Object)"impl2", (Object)t1.result);
        Assert.assertEquals((Object)"impl2", (Object)t2.result);
        Assert.assertEquals((long)1L, (long)proxyProvider.getFailoversOccurred());
    }

    @Test
    public void testFailoverBetweenMultipleStandbys() throws UnreliableInterface.UnreliableException, StandbyException, IOException {
        long millisToSleep = 10000L;
        final UnreliableImplementation impl1 = new UnreliableImplementation("impl1", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION);
        FlipFlopProxyProvider<UnreliableImplementation> proxyProvider = new FlipFlopProxyProvider<UnreliableImplementation>(UnreliableInterface.class, impl1, new UnreliableImplementation("impl2", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION));
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, proxyProvider, RetryPolicies.failoverOnNetworkException(RetryPolicies.TRY_ONCE_THEN_FAIL, 10, 1000L, 10000L));
        new Thread(){

            @Override
            public void run() {
                ThreadUtil.sleepAtLeastIgnoreInterrupts(10000L);
                impl1.setIdentifier("renamed-impl1");
            }
        }.start();
        String result = unreliable.failsIfIdentifierDoesntMatch("renamed-impl1");
        Assert.assertEquals((Object)"renamed-impl1", (Object)result);
    }

    @Test
    public void testExpectedIOException() {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.REMOTE_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), RetryPolicies.failoverOnNetworkException(RetryPolicies.TRY_ONCE_THEN_FAIL, 10, 1000L, 10000L));
        try {
            unreliable.failsIfIdentifierDoesntMatch("no-such-identifier");
            Assert.fail((String)"Should have thrown *some* exception");
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Expected IOE but got " + e.getClass()), (boolean)(e instanceof IOException));
        }
    }

    private static class ConcurrentMethodThread
    extends Thread {
        private UnreliableInterface unreliable;
        public String result;

        public ConcurrentMethodThread(UnreliableInterface unreliable) {
            this.unreliable = unreliable;
        }

        @Override
        public void run() {
            try {
                this.result = this.unreliable.failsIfIdentifierDoesntMatch("impl2");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SynchronizedUnreliableImplementation
    extends UnreliableImplementation {
        private CountDownLatch methodLatch;

        public SynchronizedUnreliableImplementation(String identifier, UnreliableImplementation.TypeOfExceptionToFailWith exceptionToFailWith, int threadCount) {
            super(identifier, exceptionToFailWith);
            this.methodLatch = new CountDownLatch(threadCount);
        }

        @Override
        public String failsIfIdentifierDoesntMatch(String identifier) throws UnreliableInterface.UnreliableException, StandbyException, IOException {
            this.methodLatch.countDown();
            try {
                this.methodLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.failsIfIdentifierDoesntMatch(identifier);
        }
    }

    public static class FailOverOnceOnAnyExceptionPolicy
    implements RetryPolicy {
        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) {
            return failovers < 1 ? RetryPolicy.RetryAction.FAILOVER_AND_RETRY : RetryPolicy.RetryAction.FAIL;
        }
    }

    public static class FlipFlopProxyProvider<T>
    implements FailoverProxyProvider<T> {
        private Class<T> iface;
        private T currentlyActive;
        private T impl1;
        private T impl2;
        private int failoversOccurred = 0;

        public FlipFlopProxyProvider(Class<T> iface, T activeImpl, T standbyImpl) {
            this.iface = iface;
            this.impl1 = activeImpl;
            this.impl2 = standbyImpl;
            this.currentlyActive = this.impl1;
        }

        @Override
        public FailoverProxyProvider.ProxyInfo<T> getProxy() {
            return new FailoverProxyProvider.ProxyInfo<T>(this.currentlyActive, this.currentlyActive.toString());
        }

        @Override
        public synchronized void performFailover(Object currentProxy) {
            this.currentlyActive = this.impl1 == currentProxy ? this.impl2 : this.impl1;
            ++this.failoversOccurred;
        }

        @Override
        public Class<T> getInterface() {
            return this.iface;
        }

        @Override
        public void close() throws IOException {
        }

        public int getFailoversOccurred() {
            return this.failoversOccurred;
        }
    }
}

