/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.UnreliableImplementation;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RemoteException;

public class TestRetryProxy
extends TestCase {
    private UnreliableImplementation unreliableImpl;

    protected void setUp() throws Exception {
        this.unreliableImpl = new UnreliableImplementation();
    }

    public void testTryOnceThenFail() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.TRY_ONCE_THEN_FAIL);
        unreliable.alwaysSucceeds();
        try {
            unreliable.failsOnceThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRpcInvocation() throws Exception {
        final UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.RETRY_FOREVER);
        TestRetryProxy.assertTrue((boolean)RetryInvocationHandler.isRpcInvocation(unreliable));
        ProtocolTranslator xlator = new ProtocolTranslator(){
            int count = 0;

            @Override
            public Object getUnderlyingProxyObject() {
                ++this.count;
                return unreliable;
            }

            public String toString() {
                return "" + this.count;
            }
        };
        TestRetryProxy.assertTrue((boolean)RetryInvocationHandler.isRpcInvocation(xlator));
        TestRetryProxy.assertEquals((String)xlator.toString(), (String)"1");
        TestRetryProxy.assertFalse((boolean)RetryInvocationHandler.isRpcInvocation(new Object()));
    }

    public void testRetryForever() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.RETRY_FOREVER);
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        unreliable.failsTenTimesThenSucceeds();
    }

    public void testRetryUpToMaximumCountWithFixedSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.retryUpToMaximumCountWithFixedSleep(8, 1L, TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRetryUpToMaximumTimeWithFixedSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.retryUpToMaximumTimeWithFixedSleep(80L, 10L, TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRetryUpToMaximumCountWithProportionalSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.retryUpToMaximumCountWithProportionalSleep(8, 1L, TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testExponentialRetry() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.exponentialBackoffRetry(5, 1L, TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRetryByException() throws UnreliableInterface.UnreliableException {
        Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.retryByException(RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.alwaysFailsWithFatalException();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.FatalException fatalException) {
            // empty catch block
        }
    }

    public void testRetryByRemoteException() {
        Map<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, this.unreliableImpl, RetryPolicies.retryByRemoteException(RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        try {
            unreliable.alwaysFailsWithRemoteFatalException();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

