/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestGenericWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.JavaSerialization;
import org.apache.hadoop.io.serializer.SerializationTestUtil;
import org.apache.hadoop.io.serializer.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class TestWritableSerialization {
    private static final Configuration conf = new Configuration();

    @Test
    public void testWritableSerialization() throws Exception {
        Text before = new Text("test writable");
        Text after = SerializationTestUtil.testSerialization(conf, before);
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testWritableConfigurable() throws Exception {
        conf.set("test.generic.writable", "dummy");
        TestGenericWritable.FooGenericWritable generic = new TestGenericWritable.FooGenericWritable();
        generic.setConf(conf);
        TestGenericWritable.Baz baz = new TestGenericWritable.Baz();
        generic.set(baz);
        TestGenericWritable.Baz result = SerializationTestUtil.testSerialization(conf, baz);
        Assert.assertEquals((Object)baz, (Object)result);
        Assert.assertNotNull((Object)result.getConf());
    }

    @Test
    public void testWritableComparatorJavaSerialization() throws Exception {
        JavaSerialization ser = new JavaSerialization();
        Serializer<TestWC> serializer = ser.getSerializer(TestWC.class);
        DataOutputBuffer dob = new DataOutputBuffer();
        serializer.open(dob);
        TestWC orig = new TestWC(0);
        serializer.serialize(orig);
        serializer.close();
        Deserializer<TestWC> deserializer = ser.getDeserializer(TestWC.class);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        deserializer.open(dib);
        TestWC deser = deserializer.deserialize(null);
        deserializer.close();
        Assert.assertEquals((Object)orig, (Object)deser);
    }

    static class TestWC
    extends WritableComparator
    implements Serializable {
        static final long serialVersionUID = 17220L;
        final int val;

        TestWC() {
            this(7);
        }

        TestWC(int val) {
            this.val = val;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof TestWC) {
                return ((TestWC)o).val == this.val;
            }
            return false;
        }

        public int hashCode() {
            return this.val;
        }
    }
}

