/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRPC;
import org.apache.hadoop.mapred.AuditLogger;
import org.apache.hadoop.net.NetUtils;

public class TestAuditLogger
extends TestCase {
    private static final String USER = "test";
    private static final String OPERATION = "oper";
    private static final String TARGET = "tgt";
    private static final String PERM = "admin group";
    private static final String DESC = "description of an audit log";

    public void testKeyValLogFormat() {
        StringBuilder actLog = new StringBuilder();
        StringBuilder expLog = new StringBuilder();
        AuditLogger.start(AuditLogger.Keys.USER, USER, actLog);
        expLog.append("USER=test");
        TestAuditLogger.assertEquals((String)expLog.toString(), (String)actLog.toString());
        AuditLogger.add(AuditLogger.Keys.OPERATION, OPERATION, actLog);
        expLog.append("\tOPERATION=oper");
        TestAuditLogger.assertEquals((String)expLog.toString(), (String)actLog.toString());
        AuditLogger.add(AuditLogger.Keys.PERMISSIONS, null, actLog);
        expLog.append("\tPERMISSIONS=null");
        TestAuditLogger.assertEquals((String)expLog.toString(), (String)actLog.toString());
        AuditLogger.add(AuditLogger.Keys.TARGET, TARGET, actLog);
        expLog.append("\tTARGET=tgt");
        TestAuditLogger.assertEquals((String)expLog.toString(), (String)actLog.toString());
    }

    private void testSuccessLogFormat(boolean checkIP) {
        String sLog = AuditLogger.createSuccessLog(USER, OPERATION, TARGET);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(AuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=SUCCESS");
        TestAuditLogger.assertEquals((String)expLog.toString(), (String)sLog);
    }

    private void testFailureLogFormat(boolean checkIP, String perm) {
        String fLog = AuditLogger.createFailureLog(USER, OPERATION, perm, TARGET, DESC);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(AuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=FAILURE\t");
        expLog.append("DESCRIPTION=description of an audit log\t");
        expLog.append("PERMISSIONS=" + perm);
        TestAuditLogger.assertEquals((String)expLog.toString(), (String)fLog);
    }

    private void testFailureLogFormat(boolean checkIP) {
        this.testFailureLogFormat(checkIP, PERM);
        this.testFailureLogFormat(checkIP, null);
    }

    public void testAuditLoggerWithoutIP() throws Exception {
        this.testSuccessLogFormat(false);
        this.testFailureLogFormat(false);
    }

    public void testAuditLoggerWithIP() throws Exception {
        Configuration conf = new Configuration();
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestRPC.TestProtocol.class).setInstance(new MyTestRPCServer()).setBindAddress("0.0.0.0").setPort(0).build();
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress(server);
        TestRPC.TestProtocol proxy = RPC.getProxy(TestRPC.TestProtocol.class, 1L, addr, conf);
        proxy.ping();
        server.stop();
    }

    @ProtocolInfo(protocolName="org.apache.hadoop.ipc.TestRPC$TestProtocol")
    private class MyTestRPCServer
    extends TestRPC.TestImpl {
        private MyTestRPCServer() {
        }

        @Override
        public void ping() {
            TestAuditLogger.this.testSuccessLogFormat(true);
            TestAuditLogger.this.testFailureLogFormat(true);
        }
    }
}

