/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileAsBinaryOutputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

public class TestSequenceFileAsBinaryOutputFormat
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestSequenceFileAsBinaryOutputFormat.class.getName());
    private static final int RECORDS = 10000;
    private static final String attempt = "attempt_200707121733_0001_m_000000_0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinary() throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal(job);
        Path dir = new Path(new Path(new Path(System.getProperty("test.build.data", ".")), "_temporary"), "_attempt_200707121733_0001_m_000000_0");
        Path file = new Path(dir, "testbinary.seq");
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        ((FileSystem)fs).delete(dir, true);
        if (!((FileSystem)fs).mkdirs(dir)) {
            TestSequenceFileAsBinaryOutputFormat.fail((String)"Failed to create output directory");
        }
        job.set("mapreduce.task.attempt.id", attempt);
        FileOutputFormat.setOutputPath(job, dir.getParent().getParent());
        FileOutputFormat.setWorkOutputPath(job, dir);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputKeyClass(job, IntWritable.class);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputValueClass(job, DoubleWritable.class);
        SequenceFileAsBinaryOutputFormat.setCompressOutput(job, true);
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType(job, SequenceFile.CompressionType.BLOCK);
        BytesWritable bkey = new BytesWritable();
        BytesWritable bval = new BytesWritable();
        RecordWriter<BytesWritable, BytesWritable> writer = new SequenceFileAsBinaryOutputFormat().getRecordWriter(fs, job, file.toString(), Reporter.NULL);
        IntWritable iwritable = new IntWritable();
        DoubleWritable dwritable = new DoubleWritable();
        DataOutputBuffer outbuf = new DataOutputBuffer();
        LOG.info((Object)"Creating data by SequenceFileAsBinaryOutputFormat");
        try {
            for (int i = 0; i < 10000; ++i) {
                iwritable = new IntWritable(r.nextInt());
                iwritable.write(outbuf);
                bkey.set(outbuf.getData(), 0, outbuf.getLength());
                outbuf.reset();
                dwritable = new DoubleWritable(r.nextDouble());
                dwritable.write(outbuf);
                bval.set(outbuf.getData(), 0, outbuf.getLength());
                outbuf.reset();
                writer.write(bkey, bval);
            }
        }
        finally {
            writer.close(Reporter.NULL);
        }
        SequenceFileInputFormat iformat = new SequenceFileInputFormat();
        int count = 0;
        r.setSeed(seed);
        DataInputBuffer buf = new DataInputBuffer();
        int NUM_SPLITS = 3;
        SequenceFileInputFormat.addInputPath(job, file);
        LOG.info((Object)"Reading data by SequenceFileInputFormat");
        for (InputSplit split : iformat.getSplits(job, 3)) {
            RecordReader<IntWritable, DoubleWritable> reader = iformat.getRecordReader(split, job, Reporter.NULL);
            try {
                while (reader.next(iwritable, dwritable)) {
                    int sourceInt = r.nextInt();
                    double sourceDouble = r.nextDouble();
                    TestSequenceFileAsBinaryOutputFormat.assertEquals((String)("Keys don't match: *" + iwritable.get() + ":" + sourceInt + "*"), (int)sourceInt, (int)iwritable.get());
                    TestSequenceFileAsBinaryOutputFormat.assertTrue((String)("Vals don't match: *" + dwritable.get() + ":" + sourceDouble + "*"), (Double.compare(dwritable.get(), sourceDouble) == 0 ? 1 : 0) != 0);
                    ++count;
                }
            }
            finally {
                reader.close();
            }
        }
        TestSequenceFileAsBinaryOutputFormat.assertEquals((String)"Some records not found", (int)10000, (int)count);
    }

    public void testSequenceOutputClassDefaultsToMapRedOutputClass() throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal(job);
        job.setOutputKeyClass(FloatWritable.class);
        job.setOutputValueClass(BooleanWritable.class);
        TestSequenceFileAsBinaryOutputFormat.assertEquals((String)"SequenceFileOutputKeyClass should default to ouputKeyClass", FloatWritable.class, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass(job));
        TestSequenceFileAsBinaryOutputFormat.assertEquals((String)"SequenceFileOutputValueClass should default to ouputValueClass", BooleanWritable.class, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass(job));
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputKeyClass(job, IntWritable.class);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputValueClass(job, DoubleWritable.class);
        TestSequenceFileAsBinaryOutputFormat.assertEquals((String)"SequenceFileOutputKeyClass not updated", IntWritable.class, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass(job));
        TestSequenceFileAsBinaryOutputFormat.assertEquals((String)"SequenceFileOutputValueClass not updated", DoubleWritable.class, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass(job));
    }

    public void testcheckOutputSpecsForbidRecordCompression() throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal(job);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path outputdir = new Path(System.getProperty("test.build.data", ".") + "/output");
        ((FileSystem)fs).delete(dir, true);
        ((FileSystem)fs).delete(outputdir, true);
        if (!((FileSystem)fs).mkdirs(dir)) {
            TestSequenceFileAsBinaryOutputFormat.fail((String)"Failed to create output directory");
        }
        FileOutputFormat.setWorkOutputPath(job, dir);
        FileOutputFormat.setOutputPath(job, outputdir);
        SequenceFileAsBinaryOutputFormat.setCompressOutput(job, true);
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType(job, SequenceFile.CompressionType.BLOCK);
        try {
            new SequenceFileAsBinaryOutputFormat().checkOutputSpecs(fs, job);
        }
        catch (Exception e) {
            TestSequenceFileAsBinaryOutputFormat.fail((String)("Block compression should be allowed for SequenceFileAsBinaryOutputFormat:Caught " + e.getClass().getName()));
        }
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType(job, SequenceFile.CompressionType.RECORD);
        try {
            new SequenceFileAsBinaryOutputFormat().checkOutputSpecs(fs, job);
            TestSequenceFileAsBinaryOutputFormat.fail((String)"Record compression should not be allowed for SequenceFileAsBinaryOutputFormat");
        }
        catch (InvalidJobConfException ie) {
        }
        catch (Exception e) {
            TestSequenceFileAsBinaryOutputFormat.fail((String)("Expected " + InvalidJobConfException.class.getName() + "but caught " + e.getClass().getName()));
        }
    }
}

