/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.GenericsUtil;

public class TestWritableJobConf
extends TestCase {
    private static final Configuration CONF = new Configuration();

    private <K> K serDeser(K conf) throws Exception {
        SerializationFactory factory = new SerializationFactory(CONF);
        Serializer<K> serializer = factory.getSerializer(GenericsUtil.getClass(conf));
        Deserializer<K> deserializer = factory.getDeserializer(GenericsUtil.getClass(conf));
        DataOutputBuffer out = new DataOutputBuffer();
        serializer.open(out);
        serializer.serialize(conf);
        serializer.close();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        deserializer.open(in);
        K after = deserializer.deserialize(null);
        deserializer.close();
        return after;
    }

    private void assertEquals(Configuration conf1, Configuration conf2) {
        Iterator<Map.Entry<String, String>> iterator1 = conf1.iterator();
        HashMap<String, String> map1 = new HashMap<String, String>();
        while (iterator1.hasNext()) {
            Map.Entry<String, String> entry = iterator1.next();
            if (Configuration.isDeprecated(entry.getKey())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
        Iterator<Map.Entry<String, String>> iterator2 = conf2.iterator();
        HashMap<String, String> map2 = new HashMap<String, String>();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> entry = iterator2.next();
            if (Configuration.isDeprecated(entry.getKey())) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        TestWritableJobConf.assertEquals(map1, map2);
    }

    public void testEmptyConfiguration() throws Exception {
        JobConf conf = new JobConf();
        Configuration deser = this.serDeser(conf);
        this.assertEquals(conf, deser);
    }

    public void testNonEmptyConfiguration() throws Exception {
        JobConf conf = new JobConf();
        conf.set("a", "A");
        conf.set("b", "B");
        Configuration deser = this.serDeser(conf);
        this.assertEquals(conf, deser);
    }

    public void testConfigurationWithDefaults() throws Exception {
        JobConf conf = new JobConf(false);
        conf.set("a", "A");
        conf.set("b", "B");
        Configuration deser = this.serDeser(conf);
        this.assertEquals(conf, deser);
    }
}

