/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.MultipleInputs;

public class TestMultipleInputs
extends TestCase {
    public void testAddInputPathWithFormat() {
        JobConf conf = new JobConf();
        MultipleInputs.addInputPath(conf, new Path("/foo"), TextInputFormat.class);
        MultipleInputs.addInputPath(conf, new Path("/bar"), KeyValueTextInputFormat.class);
        Map<Path, InputFormat> inputs = MultipleInputs.getInputFormatMap(conf);
        TestMultipleInputs.assertEquals(TextInputFormat.class, inputs.get(new Path("/foo")).getClass());
        TestMultipleInputs.assertEquals(KeyValueTextInputFormat.class, inputs.get(new Path("/bar")).getClass());
    }

    public void testAddInputPathWithMapper() {
        JobConf conf = new JobConf();
        MultipleInputs.addInputPath(conf, new Path("/foo"), TextInputFormat.class, MapClass.class);
        MultipleInputs.addInputPath(conf, new Path("/bar"), KeyValueTextInputFormat.class, MapClass2.class);
        Map<Path, InputFormat> inputs = MultipleInputs.getInputFormatMap(conf);
        Map<Path, Class<? extends Mapper>> maps = MultipleInputs.getMapperTypeMap(conf);
        TestMultipleInputs.assertEquals(TextInputFormat.class, inputs.get(new Path("/foo")).getClass());
        TestMultipleInputs.assertEquals(KeyValueTextInputFormat.class, inputs.get(new Path("/bar")).getClass());
        TestMultipleInputs.assertEquals(MapClass.class, maps.get(new Path("/foo")));
        TestMultipleInputs.assertEquals(MapClass2.class, maps.get(new Path("/bar")));
    }

    static class MapClass2
    extends MapClass {
        MapClass2() {
        }
    }

    static class MapClass
    implements Mapper<String, String, String, String> {
        MapClass() {
        }

        @Override
        public void map(String key, String value, OutputCollector<String, String> output, Reporter reporter) throws IOException {
        }

        @Override
        public void configure(JobConf job) {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

