/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.text.NumberFormat;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorMapper;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorReducer;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;

public class TestAggregates
extends TestCase {
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public void testAggregates() throws Exception {
        TestAggregates.launch();
    }

    public static void launch() throws Exception {
        JobConf conf = new JobConf(TestAggregates.class);
        FileSystem fs = FileSystem.get(conf);
        int numOfInputLines = 20;
        Path OUTPUT_DIR = new Path("build/test/output_for_aggregates_test");
        Path INPUT_DIR = new Path("build/test/input_for_aggregates_test");
        String inputFile = "input.txt";
        fs.delete(INPUT_DIR, true);
        fs.mkdirs(INPUT_DIR);
        fs.delete(OUTPUT_DIR, true);
        StringBuffer inputData = new StringBuffer();
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append("max\t19\n");
        expectedOutput.append("min\t1\n");
        FSDataOutputStream fileOut = fs.create(new Path(INPUT_DIR, inputFile));
        for (int i = 1; i < numOfInputLines; ++i) {
            expectedOutput.append("count_").append(idFormat.format(i));
            expectedOutput.append("\t").append(i).append("\n");
            inputData.append(idFormat.format(i));
            for (int j = 1; j < i; ++j) {
                inputData.append(" ").append(idFormat.format(i));
            }
            inputData.append("\n");
        }
        expectedOutput.append("value_as_string_max\t9\n");
        expectedOutput.append("value_as_string_min\t1\n");
        expectedOutput.append("uniq_count\t15\n");
        fileOut.write(inputData.toString().getBytes("utf-8"));
        fileOut.close();
        System.out.println("inputData:");
        System.out.println(inputData.toString());
        JobConf job = new JobConf(conf, TestAggregates.class);
        FileInputFormat.setInputPaths(job, INPUT_DIR);
        job.setInputFormat(TextInputFormat.class);
        FileOutputFormat.setOutputPath(job, OUTPUT_DIR);
        job.setOutputFormat(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        job.setMapperClass(ValueAggregatorMapper.class);
        job.setReducerClass(ValueAggregatorReducer.class);
        job.setCombinerClass(ValueAggregatorCombiner.class);
        job.setInt("aggregator.descriptor.num", 1);
        job.set("aggregator.descriptor.0", "UserDefined,org.apache.hadoop.mapred.lib.aggregate.AggregatorTests");
        job.setLong("aggregate.max.num.unique.values", 14L);
        JobClient.runJob(job);
        boolean success = true;
        Path outPath = new Path(OUTPUT_DIR, "part-00000");
        String outdata = MapReduceTestUtil.readOutput(outPath, job);
        System.out.println("full out data:");
        System.out.println(outdata.toString());
        outdata = outdata.substring(0, expectedOutput.toString().length());
        TestAggregates.assertEquals((String)expectedOutput.toString(), (String)outdata);
        fs.delete(INPUT_DIR, true);
    }

    public static void main(String[] argv) throws Exception {
        TestAggregates.launch();
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }
}

