/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.counters.LimitExceededException;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.junit.Assert;
import org.junit.Test;

public class TestCounters {
    static final Log LOG = LogFactory.getLog(TestCounters.class);
    static final Enum<?> FRAMEWORK_COUNTER = TaskCounter.CPU_MILLISECONDS;
    static final long FRAMEWORK_COUNTER_VALUE = 8L;
    static final String FS_SCHEME = "HDFS";
    static final FileSystemCounter FS_COUNTER = FileSystemCounter.BYTES_READ;
    static final long FS_COUNTER_VALUE = 10L;

    @Test
    public void testCounterValue() {
        int NUMBER_TESTS = 100;
        int NUMBER_INC = 10;
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            long initValue;
            long expectedValue = initValue = (long)rand.nextInt();
            Object counter = new Counters().findCounter("test", "foo");
            counter.setValue(initValue);
            Assert.assertEquals((String)"Counter value is not initialized correctly", (long)expectedValue, (long)counter.getValue());
            for (int j = 0; j < 10; ++j) {
                int incValue = rand.nextInt();
                counter.increment(incValue);
                Assert.assertEquals((String)"Counter value is not incremented correctly", (long)(expectedValue += (long)incValue), (long)counter.getValue());
            }
            expectedValue = rand.nextInt();
            counter.setValue(expectedValue);
            Assert.assertEquals((String)"Counter value is not set correctly", (long)expectedValue, (long)counter.getValue());
        }
    }

    @Test
    public void testLimits() {
        for (int i = 0; i < 3; ++i) {
            this.testMaxCounters(new Counters());
            this.testMaxGroups(new Counters());
        }
    }

    @Test
    public void testCountersIncrement() {
        Counters fCounters = new Counters();
        Object fCounter = fCounters.findCounter(FRAMEWORK_COUNTER);
        fCounter.setValue(100L);
        Object gCounter = fCounters.findCounter("test", "foo");
        gCounter.setValue(200L);
        Counters counters = new Counters();
        counters.incrAllCounters(fCounters);
        for (CounterGroup cg : fCounters) {
            Object counter;
            CounterGroup group = (CounterGroup)counters.getGroup(cg.getName());
            if (group.getName().equals("test")) {
                counter = counters.findCounter("test", "foo");
                Assert.assertEquals((long)200L, (long)counter.getValue());
                continue;
            }
            counter = counters.findCounter(FRAMEWORK_COUNTER);
            Assert.assertEquals((long)100L, (long)counter.getValue());
        }
    }

    private void testMaxCounters(final Counters counters) {
        LOG.info((Object)("counters max=" + Limits.getCountersMax()));
        for (int i = 0; i < Limits.getCountersMax(); ++i) {
            counters.findCounter("test", "test" + i);
        }
        this.setExpected(counters);
        this.shouldThrow(LimitExceededException.class, new Runnable(){

            @Override
            public void run() {
                counters.findCounter("test", "bad");
            }
        });
        this.checkExpected(counters);
    }

    private void testMaxGroups(final Counters counters) {
        LOG.info((Object)("counter groups max=" + Limits.getGroupsMax()));
        for (int i = 0; i < Limits.getGroupsMax(); ++i) {
            counters.findCounter("test" + i, "test");
        }
        this.setExpected(counters);
        this.shouldThrow(LimitExceededException.class, new Runnable(){

            @Override
            public void run() {
                counters.findCounter("bad", "test");
            }
        });
        this.checkExpected(counters);
    }

    private void setExpected(Counters counters) {
        counters.findCounter(FRAMEWORK_COUNTER).setValue(8L);
        counters.findCounter(FS_SCHEME, FS_COUNTER).setValue(10L);
    }

    private void checkExpected(Counters counters) {
        Assert.assertEquals((long)8L, (long)counters.findCounter(FRAMEWORK_COUNTER).getValue());
        Assert.assertEquals((long)10L, (long)counters.findCounter(FS_SCHEME, FS_COUNTER).getValue());
    }

    private void shouldThrow(Class<? extends Exception> ecls, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            Assert.assertSame(ecls, e.getClass());
            LOG.info((Object)("got expected: " + e));
            return;
        }
        Assert.assertTrue((String)("Should've thrown " + ecls.getSimpleName()), (boolean)false);
    }
}

