/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapreduce.LargeSorter;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLargeSort {
    MiniMRClientCluster cluster;

    @Before
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        this.cluster = MiniMRClientClusterFactory.create(this.getClass(), 2, conf);
        this.cluster.start();
    }

    @After
    public void cleanup() throws IOException {
        if (this.cluster != null) {
            this.cluster.stop();
            this.cluster = null;
        }
    }

    @Test
    public void testLargeSort() throws Exception {
        int[] ioSortMbs;
        String[] args = new String[]{};
        for (int ioSortMb : ioSortMbs = new int[]{128, 256, 1536}) {
            Configuration conf = new Configuration(this.cluster.getConfig());
            conf.setInt("mapreduce.task.io.sort.mb", ioSortMb);
            conf.setInt("mapreduce.large-sorter.map-tasks", 1);
            conf.setInt("mapreduce.large-sorter.mbs-per-map", ioSortMb);
            Assert.assertEquals((String)("Large sort failed for " + ioSortMb), (long)0L, (long)ToolRunner.run(conf, new LargeSorter(), args));
        }
    }
}

