/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.join.CompositeInputFormat;
import org.apache.hadoop.mapreduce.lib.join.CompositeRecordReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public class TestWrappedRRClassloader
extends TestCase {
    public void testClassLoader() throws Exception {
        Configuration conf = new Configuration();
        Fake_ClassLoader classLoader = new Fake_ClassLoader();
        conf.setClassLoader(classLoader);
        TestWrappedRRClassloader.assertTrue((boolean)(conf.getClassLoader() instanceof Fake_ClassLoader));
        FileSystem fs = FileSystem.get(conf);
        Path testdir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(fs);
        Path base = new Path(testdir, "/empty");
        Path[] src = new Path[]{new Path(base, "i0"), new Path("i1"), new Path("i2")};
        conf.set("mapreduce.join.expr", CompositeInputFormat.compose("outer", IF_ClassLoaderChecker.class, src));
        CompositeInputFormat inputFormat = new CompositeInputFormat();
        TaskAttemptID tid = new TaskAttemptID("jt", 1, TaskType.MAP, 0, 0);
        conf.set("mapreduce.task.attempt.id", tid.toString());
        inputFormat.createRecordReader(inputFormat.getSplits(Job.getInstance(conf)).get(0), new TaskAttemptContextImpl(conf, tid));
    }

    public static class RR_ClassLoaderChecker<K, V>
    extends MapReduceTestUtil.Fake_RR<K, V> {
        public RR_ClassLoaderChecker(Configuration conf) {
            Assert.assertTrue((String)("The class loader has not been inherited from " + CompositeRecordReader.class.getSimpleName()), (boolean)(conf.getClassLoader() instanceof Fake_ClassLoader));
        }
    }

    public static class IF_ClassLoaderChecker<K, V>
    extends MapReduceTestUtil.Fake_IF<K, V> {
        @Override
        public RecordReader<K, V> createRecordReader(InputSplit ignored, TaskAttemptContext context) {
            return new RR_ClassLoaderChecker(context.getConfiguration());
        }
    }

    public static class Fake_ClassLoader
    extends ClassLoader {
    }
}

