/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.InputSampler;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.junit.Assert;
import org.junit.Test;

public class TestInputSampler {
    @Test
    public void testSplitSampler() throws Exception {
        int TOT_SPLITS = 15;
        int NUM_SPLITS = 5;
        int STEP_SAMPLE = 5;
        int NUM_SAMPLES = 25;
        InputSampler.SplitSampler<IntWritable, NullWritable> sampler = new InputSampler.SplitSampler<IntWritable, NullWritable>(25, 5);
        int[] inits = new int[15];
        for (int i = 0; i < 15; ++i) {
            inits[i] = i * 5;
        }
        Job ignored = Job.getInstance();
        IntWritable[] samples = sampler.getSample(new TestInputSamplerIF(100000, 15, inits), ignored);
        Assert.assertEquals((long)25L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 25; ++i) {
            Assert.assertEquals((long)i, (long)samples[i].get());
        }
    }

    @Test(timeout=30000L)
    public void testMapredSplitSampler() throws Exception {
        int TOT_SPLITS = 15;
        int NUM_SPLITS = 5;
        int STEP_SAMPLE = 5;
        int NUM_SAMPLES = 25;
        InputSampler.SplitSampler<IntWritable, NullWritable> sampler = new InputSampler.SplitSampler<IntWritable, NullWritable>(25, 5);
        int[] inits = new int[15];
        for (int i = 0; i < 15; ++i) {
            inits[i] = i * 5;
        }
        IntWritable[] samples = sampler.getSample(new TestMapredInputSamplerIF(100000, 15, inits), new JobConf());
        Assert.assertEquals((long)25L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 25; ++i) {
            Assert.assertEquals((long)(i % 5 + 15 * (i / 5)), (long)samples[i].get());
        }
    }

    @Test
    public void testIntervalSampler() throws Exception {
        int TOT_SPLITS = 16;
        int PER_SPLIT_SAMPLE = 4;
        int NUM_SAMPLES = 64;
        double FREQ = 0.0625;
        InputSampler.IntervalSampler<IntWritable, NullWritable> sampler = new InputSampler.IntervalSampler<IntWritable, NullWritable>(0.0625, 64);
        int[] inits = new int[16];
        for (int i = 0; i < 16; ++i) {
            inits[i] = i;
        }
        Job ignored = Job.getInstance();
        IntWritable[] samples = sampler.getSample(new TestInputSamplerIF(64, 16, inits), ignored);
        Assert.assertEquals((long)64L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((long)i, (long)samples[i].get());
        }
    }

    @Test(timeout=30000L)
    public void testMapredIntervalSampler() throws Exception {
        int TOT_SPLITS = 16;
        int PER_SPLIT_SAMPLE = 4;
        int NUM_SAMPLES = 64;
        double FREQ = 0.0625;
        InputSampler.IntervalSampler<IntWritable, NullWritable> sampler = new InputSampler.IntervalSampler<IntWritable, NullWritable>(0.0625, 64);
        int[] inits = new int[16];
        for (int i = 0; i < 16; ++i) {
            inits[i] = i;
        }
        Job ignored = Job.getInstance();
        IntWritable[] samples = sampler.getSample(new TestInputSamplerIF(64, 16, inits), ignored);
        Assert.assertEquals((long)64L, (long)samples.length);
        Arrays.sort(samples, new IntWritable.Comparator());
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((long)i, (long)samples[i].get());
        }
    }

    static class TestMapredInputSamplerIF
    extends TestInputSamplerIF
    implements org.apache.hadoop.mapred.InputFormat<IntWritable, NullWritable> {
        TestMapredInputSamplerIF(int maxDepth, int numSplits, int ... splitInit) {
            super(maxDepth, numSplits, splitInit);
        }

        @Override
        public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            List<InputSplit> splits = null;
            try {
                splits = this.getSplits(Job.getInstance(job));
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            org.apache.hadoop.mapred.InputSplit[] retVals = new org.apache.hadoop.mapred.InputSplit[splits.size()];
            for (int i = 0; i < splits.size(); ++i) {
                MapredSequentialSplit split = new MapredSequentialSplit(((SequentialSplit)splits.get(i)).getInit());
                retVals[i] = split;
            }
            return retVals;
        }

        @Override
        public org.apache.hadoop.mapred.RecordReader<IntWritable, NullWritable> getRecordReader(final org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new org.apache.hadoop.mapred.RecordReader<IntWritable, NullWritable>(){
                private final IntWritable i;
                private int maxVal;
                {
                    this.i = new IntWritable(((MapredSequentialSplit)split).getInit());
                    this.maxVal = this.i.get() + TestMapredInputSamplerIF.this.maxDepth + 1;
                }

                @Override
                public boolean next(IntWritable key, NullWritable value) throws IOException {
                    this.i.set(this.i.get() + 1);
                    return this.i.get() < this.maxVal;
                }

                @Override
                public IntWritable createKey() {
                    return new IntWritable(this.i.get());
                }

                @Override
                public NullWritable createValue() {
                    return NullWritable.get();
                }

                @Override
                public long getPos() throws IOException {
                    return 0L;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public float getProgress() throws IOException {
                    return 0.0f;
                }
            };
        }
    }

    static class TestInputSamplerIF
    extends InputFormat<IntWritable, NullWritable> {
        final int maxDepth;
        final ArrayList<InputSplit> splits = new ArrayList();

        TestInputSamplerIF(int maxDepth, int numSplits, int ... splitInit) {
            this.maxDepth = maxDepth;
            assert (splitInit.length == numSplits);
            for (int i = 0; i < numSplits; ++i) {
                this.splits.add(new SequentialSplit(splitInit[i]));
            }
        }

        @Override
        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            return this.splits;
        }

        @Override
        public RecordReader<IntWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return new RecordReader<IntWritable, NullWritable>(){
                private int maxVal;
                private final IntWritable i = new IntWritable();

                @Override
                public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                    this.i.set(((SequentialSplit)split).getInit() - 1);
                    this.maxVal = this.i.get() + TestInputSamplerIF.this.maxDepth + 1;
                }

                @Override
                public boolean nextKeyValue() {
                    this.i.set(this.i.get() + 1);
                    return this.i.get() < this.maxVal;
                }

                @Override
                public IntWritable getCurrentKey() {
                    return this.i;
                }

                @Override
                public NullWritable getCurrentValue() {
                    return NullWritable.get();
                }

                @Override
                public float getProgress() {
                    return 1.0f;
                }

                @Override
                public void close() {
                }
            };
        }
    }

    static class MapredSequentialSplit
    implements org.apache.hadoop.mapred.InputSplit {
        private int i;

        MapredSequentialSplit(int i) {
            this.i = i;
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public String[] getLocations() {
            return new String[0];
        }

        public int getInit() {
            return this.i;
        }

        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void readFields(DataInput in) throws IOException {
        }
    }

    static class SequentialSplit
    extends InputSplit {
        private int i;

        SequentialSplit(int i) {
            this.i = i;
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public String[] getLocations() {
            return new String[0];
        }

        public int getInit() {
            return this.i;
        }
    }
}

