/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CredentialsTestJob
extends Configured
implements Tool {
    private static final int NUM_OF_KEYS = 10;

    private static void checkSecrets(Credentials ts) {
        if (ts == null) {
            throw new RuntimeException("The credentials are not available");
        }
        for (int i = 0; i < 10; ++i) {
            String secretName = "alias" + i;
            byte[] secretValue = ts.getSecretKey(new Text(secretName));
            System.out.println(secretValue);
            if (secretValue == null) {
                throw new RuntimeException("The key " + secretName + " is not available. ");
            }
            String secretValueStr = new String(secretValue);
            if (("password" + i).equals(secretValueStr)) continue;
            throw new RuntimeException("The key " + secretName + " is not correct. Expected value is " + "password" + i + ". Actual value is " + secretValueStr);
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run(new Configuration(), new CredentialsTestJob(), args);
        System.exit(res);
    }

    public Job createJob() throws IOException {
        Configuration conf = this.getConf();
        conf.setInt("mapreduce.job.maps", 1);
        Job job = Job.getInstance(conf, "test");
        job.setNumReduceTasks(1);
        job.setJarByClass(CredentialsTestJob.class);
        job.setNumReduceTasks(1);
        job.setMapperClass(CredentialsTestMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(CredentialsTestReducer.class);
        job.setInputFormatClass(SleepJob.SleepInputFormat.class);
        job.setPartitionerClass(SleepJob.SleepJobPartitioner.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setSpeculativeExecution(false);
        job.setJobName("test job");
        FileInputFormat.addInputPath(job, new Path("ignored"));
        return job;
    }

    @Override
    public int run(String[] args) throws Exception {
        Job job = this.createJob();
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class CredentialsTestReducer
    extends Reducer<IntWritable, NullWritable, NullWritable, NullWritable> {
        Credentials ts;

        @Override
        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.ts = context.getCredentials();
        }

        @Override
        public void reduce(IntWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException {
            CredentialsTestJob.checkSecrets(this.ts);
        }
    }

    public static class CredentialsTestMapper
    extends Mapper<IntWritable, IntWritable, IntWritable, NullWritable> {
        Credentials ts;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.ts = context.getCredentials();
        }

        @Override
        public void map(IntWritable key, IntWritable value, Mapper.Context context) throws IOException, InterruptedException {
            CredentialsTestJob.checkSecrets(this.ts);
        }
    }
}

